﻿var Debugger;
(function (Debugger) {
    (function (ManagedMemoryAnalyzer) {
        (function (HeapViewer) {
            Plugin.addEventListener("pluginready", function () {
                try  {
                    var apex = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.Test.Apex.VisualStudio.JavaScriptInjection.ApexExtensionMarshaler", {}, true);
                    if (apex !== null) {
                        apex._call("getApexJavaScript").done(function (result) {
                            if (result) {
                                console.log("got apex javascript files");
                                var scriptObj = document.createElement("script");
                                scriptObj.setAttribute("type", "text/javascript");
                                scriptObj.setAttribute("src", result);
                                var head = document.getElementsByTagName("head");
                                if (!head) {
                                    console.log("Unable to add apex script to document");
                                } else {
                                    head[0].appendChild(scriptObj);
                                    console.log("Added ApexJSExtension '" + result + "' to document");
                                }
                            } else {
                                console.log("no file was returned by getApexJavaScript, cannot inject TestExtension.ts for ApexJS framework");
                            }
                        }, function (error) {
                            console.log("Error when calling getApexJavaScript function:" + String(error));
                        });
                    } else {
                        console.log("Unable to connect to port marshaler 'Microsoft.Test.Apex.VisualStudio.JavaScriptInjection.ApexExtensionMarshaler'");
                    }
                } catch (e) {
                    console.log(e.toString());
                }
            });
        })(ManagedMemoryAnalyzer.HeapViewer || (ManagedMemoryAnalyzer.HeapViewer = {}));
        var HeapViewer = ManagedMemoryAnalyzer.HeapViewer;
    })(Debugger.ManagedMemoryAnalyzer || (Debugger.ManagedMemoryAnalyzer = {}));
    var ManagedMemoryAnalyzer = Debugger.ManagedMemoryAnalyzer;
})(Debugger || (Debugger = {}));
var Debugger;
(function (Debugger) {
    (function (ManagedMemoryAnalyzer) {
        (function (HeapViewer) {
            var HorizontalSplitter = (function () {
                function HorizontalSplitter(splitter, ratio, updateCallback) {
                    var _this = this;
                    this.SplitRatioMin = 0.1;
                    this.SplitRatioMax = 0.9;
                    this._updateCallback = updateCallback;
                    this._splitter = splitter;
                    this._splitRatio = ratio;
                    this._isActive = false;
                    this._splitterHeight = splitter.getBoundingClientRect().height;
                    this._container = splitter.parentElement;
                    this._top = this._container.children[0];
                    this._bottom = this._container.children[2];

                    this._splitter.style.cursor = "ns-resize";
                    this._splitter.addEventListener("mousedown", function (e) {
                        return _this.onMouseDown(e);
                    });
                    window.addEventListener("mouseup", function (e) {
                        return _this.onMouseUp(e);
                    });
                    this._container.addEventListener("mousemove", function (e) {
                        return _this.onMouseMove(e);
                    });

                    this.updateLayout();

                    window.addEventListener('resize', function () {
                        _this.updateLayout();
                    });
                    this._container.addEventListener('resize', function () {
                        _this.updateLayout();
                    });
                }
                HorizontalSplitter.prototype.updateLayout = function (mouseY) {
                    var parent = this._container.parentElement;
                    var parentRect = parent.getBoundingClientRect();
                    var containerRect = this._container.getBoundingClientRect();
                    var containerHeight = (parentRect.height - containerRect.top) + "px";
                    if (this._container.style.height !== containerHeight) {
                        this._container.style.height = containerHeight;
                    }

                    containerRect = this._container.getBoundingClientRect();
                    var topHeight = 0;
                    var bottomHeight = 0;
                    var ratio = 0;

                    var splitterPosition = mouseY - containerRect.top;
                    if (splitterPosition) {
                        topHeight = splitterPosition - this._splitterHeight / 2;
                        bottomHeight = containerRect.height - this._splitterHeight / 2 - splitterPosition;
                        ratio = (topHeight + this._splitterHeight / 2) / containerRect.height;
                    } else {
                        ratio = this._splitRatio;
                        topHeight = Math.floor(ratio * containerRect.height - this._splitterHeight / 2);
                        bottomHeight = Math.floor((1 - ratio) * containerRect.height - this._splitterHeight / 2);
                    }

                    if (ratio >= this.SplitRatioMin && ratio <= this.SplitRatioMax) {
                        this._splitRatio = ratio;

                        this._top.style.top = "0px";
                        this._top.style.height = topHeight.toString() + "px";

                        this._bottom.style.top = (topHeight + this._splitterHeight).toString() + "px";
                        this._bottom.style.height = bottomHeight.toString() + "px";

                        this._splitter.style.top = topHeight.toString() + "px";
                    }
                };

                HorizontalSplitter.prototype.onMouseDown = function (e) {
                    this._isActive = true;
                };

                HorizontalSplitter.prototype.onMouseUp = function (e) {
                    if (this._isActive) {
                        this._isActive = false;
                        this._updateCallback();
                    }
                };

                HorizontalSplitter.prototype.onMouseMove = function (e) {
                    if (this._isActive) {
                        var containerRect = this._container.getBoundingClientRect();
                        this.updateLayout(e.pageY);
                        e.stopImmediatePropagation();
                        e.preventDefault();
                    }
                };
                return HorizontalSplitter;
            })();
            HeapViewer.HorizontalSplitter = HorizontalSplitter;
        })(ManagedMemoryAnalyzer.HeapViewer || (ManagedMemoryAnalyzer.HeapViewer = {}));
        var HeapViewer = ManagedMemoryAnalyzer.HeapViewer;
    })(Debugger.ManagedMemoryAnalyzer || (Debugger.ManagedMemoryAnalyzer = {}));
    var ManagedMemoryAnalyzer = Debugger.ManagedMemoryAnalyzer;
})(Debugger || (Debugger = {}));
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Debugger;
(function (Debugger) {
    (function (ManagedMemoryAnalyzer) {
        (function (HeapViewer) {
            var MMADynamicGridViewer = (function (_super) {
                __extends(MMADynamicGridViewer, _super);
                function MMADynamicGridViewer(dataArray, root, options) {
                    _super.call(this, dataArray, root, options);

                    this._dataTipShown = false;
                    this._dataTipActivationCookie = 0;
                }
                MMADynamicGridViewer.prototype._trySorting = function (sortOrder, sortColumns) {
                    this.options().sortOrders = sortOrder;
                };

                MMADynamicGridViewer.prototype.getDatatipCell = function (e, element) {
                    return null;
                };

                MMADynamicGridViewer.prototype.createElementWithClass = function (tagName, className) {
                    var _this = this;
                    var element = _super.prototype.createElementWithClass.call(this, tagName, className);

                    if (className === "grid-cell" || className === "grid-cell-ref") {
                        element.addEventListener("mouseover", function (e) {
                            return _this.onColumnMouseOver(e, element);
                        });
                        element.addEventListener("mouseout", function (e) {
                            return _this.onColumnMouseOut(e, element);
                        });
                        element.addEventListener("mousedown", function (e) {
                            _this.tryToCloseDataTip(true);
                        });
                    }
                    return element;
                };

                MMADynamicGridViewer.prototype.onColumnMouseOver = function (e, element) {
                    var _this = this;
                    this.tryToCloseDataTip(true);

                    if (this._treeIconMouseOver)
                        return;

                    var valueColumnElement = this.getDatatipCell(e, element);
                    if (!valueColumnElement) {
                        return;
                    }

                    valueColumnElement.removeAttribute("data-plugin-vs-tooltip");
                    this._dataTipActivationCookie = window.setTimeout(function () {
                        if (_this._dataTipActivationCookie) {
                            _this.activateValueDataTip(e, valueColumnElement);
                        }
                    }, 300);
                };

                MMADynamicGridViewer.prototype.onColumnMouseOut = function (e, element) {
                    if (this._dataTipActivationCookie) {
                        window.clearTimeout(this._dataTipActivationCookie);
                        this._dataTipActivationCookie = 0;
                    }
                    if (this._dataTipShown) {
                        var toElement = e.toElement;
                        var forceClose = !!toElement && (toElement.classList.contains("grid-row") || toElement.classList.contains("grid-cell") || toElement.classList.contains("grid-cell-ref"));
                        this.tryToCloseDataTip(forceClose);
                    }
                };

                MMADynamicGridViewer.prototype.activateValueDataTip = function (e, valueColumn) {
                    var _this = this;
                    var row = valueColumn.parentElement;
                    if (!row) {
                        return;
                    }

                    var rowInfo = this.getRowInfoFromEvent(e, "." + row.classList.item(0));
                    if (!rowInfo) {
                        return;
                    }
                    var dataIndex = (rowInfo.dataIndex);

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        var columnRect = valueColumn.getBoundingClientRect();

                        var x = Math.round(e.clientX);
                        var y = Math.round(e.clientY);
                        var left = Math.round(columnRect.left);
                        var right = Math.round(columnRect.right);
                        var top = Math.round(columnRect.top);
                        var bottom = Math.round(columnRect.bottom);
                        var isMousePointerInsideTheColumn = x >= left && x <= right && y >= top && y <= bottom;
                        if (isMousePointerInsideTheColumn) {
                            var dataTipInfo = {
                                "tag": tag,
                                "x": x + 20,
                                "y": top,
                                "left": left,
                                "top": top,
                                "right": right,
                                "bottom": bottom
                            };
                            _this._dataTipShown = true;
                            _this.adaptor()._call("ShowDataTip", dataTipInfo);
                        }
                    });
                };

                MMADynamicGridViewer.prototype.tryToCloseDataTip = function (closeForcefully) {
                    var _this = this;
                    if (closeForcefully) {
                        window.clearTimeout(this._dataTipActivationCookie);
                    }
                    try  {
                        this.adaptor()._call("CloseDataTip", closeForcefully).done(function (dataTipHasBeenClosed) {
                            if (dataTipHasBeenClosed) {
                                _this._dataTipShown = false;
                            }
                        });
                    } catch (err) {
                    }
                };

                MMADynamicGridViewer.prototype.onTreeIconMouseOver = function (e) {
                    this._treeIconMouseOver = true;
                    this.tryToCloseDataTip(true);
                };

                MMADynamicGridViewer.prototype.onTreeIconMouseOut = function (e) {
                    this._treeIconMouseOver = false;
                };

                MMADynamicGridViewer.prototype._onBlur = function (e) {
                    this.tryToCloseDataTip(false);
                    _super.prototype._onBlur.call(this, e);
                };

                MMADynamicGridViewer.prototype.addWatch = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        _this.adaptor()._call("AddWatch", tag);
                    });
                };

                MMADynamicGridViewer.prototype.quickWatch = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        _this.tryToCloseDataTip(true);
                        var tag = value["Tag"];
                        _this.adaptor()._call("QuickWatch", tag);
                    });
                };
                return MMADynamicGridViewer;
            })(Common.Controls.DynamicGrid.DynamicGridViewer);
            HeapViewer.MMADynamicGridViewer = MMADynamicGridViewer;
        })(ManagedMemoryAnalyzer.HeapViewer || (ManagedMemoryAnalyzer.HeapViewer = {}));
        var HeapViewer = ManagedMemoryAnalyzer.HeapViewer;
    })(Debugger.ManagedMemoryAnalyzer || (Debugger.ManagedMemoryAnalyzer = {}));
    var ManagedMemoryAnalyzer = Debugger.ManagedMemoryAnalyzer;
})(Debugger || (Debugger = {}));
var Debugger;
(function (Debugger) {
    (function (ManagedMemoryAnalyzer) {
        (function (HeapViewer) {
            var RefGraphDirection;
            (function (RefGraphDirection) {
                RefGraphDirection[RefGraphDirection["Forward"] = 0] = "Forward";
                RefGraphDirection[RefGraphDirection["Backward"] = 1] = "Backward";
            })(RefGraphDirection || (RefGraphDirection = {}));
            ;

            var ViewType;
            (function (ViewType) {
                ViewType[ViewType["TypesView"] = 0] = "TypesView";
                ViewType[ViewType["ObjectsView"] = 1] = "ObjectsView";
            })(ViewType || (ViewType = {}));
            ;

            var SnapshotType;
            (function (SnapshotType) {
                SnapshotType[SnapshotType["GC_DUMP"] = 1] = "GC_DUMP";
                SnapshotType[SnapshotType["LIVE"] = 2] = "LIVE";
                SnapshotType[SnapshotType["X86_DUMP"] = 3] = "X86_DUMP";
                SnapshotType[SnapshotType["X64_DUMP"] = 4] = "X64_DUMP";
                SnapshotType[SnapshotType["ARM_DUMP"] = 5] = "ARM_DUMP";
            })(SnapshotType || (SnapshotType = {}));
            ;

            var DiffResult;
            (function (DiffResult) {
                DiffResult[DiffResult["SUCCESS"] = 0] = "SUCCESS";
                DiffResult[DiffResult["FAILURE"] = 1] = "FAILURE";
            })(DiffResult || (DiffResult = {}));
            ;

            var HeapViewBroadcastEventType;
            (function (HeapViewBroadcastEventType) {
                HeapViewBroadcastEventType[HeapViewBroadcastEventType["ANALYSIS_COMPLETE_SUCCESS"] = 0] = "ANALYSIS_COMPLETE_SUCCESS";
                HeapViewBroadcastEventType[HeapViewBroadcastEventType["SNAPSHOT_DESTROY"] = 1] = "SNAPSHOT_DESTROY";
                HeapViewBroadcastEventType[HeapViewBroadcastEventType["VIEW_FILTER_CHANGED"] = 2] = "VIEW_FILTER_CHANGED";
                HeapViewBroadcastEventType[HeapViewBroadcastEventType["ANALYSIS_ERROR"] = 3] = "ANALYSIS_ERROR";
            })(HeapViewBroadcastEventType || (HeapViewBroadcastEventType = {}));
            ;

            var ContextMenuType;
            (function (ContextMenuType) {
                ContextMenuType[ContextMenuType["First"] = 0] = "First";
                ContextMenuType[ContextMenuType["Types"] = 0] = "Types";
                ContextMenuType[ContextMenuType["Objects"] = 1] = "Objects";
                ContextMenuType[ContextMenuType["BackwardRefGraph"] = 2] = "BackwardRefGraph";
                ContextMenuType[ContextMenuType["ForwardRefGraph"] = 3] = "ForwardRefGraph";
                ContextMenuType[ContextMenuType["BackwardTypesRefGraph"] = 4] = "BackwardTypesRefGraph";
                ContextMenuType[ContextMenuType["ForwardTypesRefGraph"] = 5] = "ForwardTypesRefGraph";
                ContextMenuType[ContextMenuType["Last"] = ContextMenuType.ForwardTypesRefGraph] = "Last";
            })(ContextMenuType || (ContextMenuType = {}));
            ;

            var ContextMenuItem;
            (function (ContextMenuItem) {
                ContextMenuItem[ContextMenuItem["Copy"] = 0] = "Copy";
                ContextMenuItem[ContextMenuItem["Separator1"] = 1] = "Separator1";
                ContextMenuItem[ContextMenuItem["AddWatch"] = 2] = "AddWatch";
                ContextMenuItem[ContextMenuItem["QuickWatch"] = 3] = "QuickWatch";
                ContextMenuItem[ContextMenuItem["ViewInstances"] = 4] = "ViewInstances";
                ContextMenuItem[ContextMenuItem["Separator2"] = 5] = "Separator2";
                ContextMenuItem[ContextMenuItem["GoToDefinition"] = 6] = "GoToDefinition";
                ContextMenuItem[ContextMenuItem["FindAllReferences"] = 7] = "FindAllReferences";
            })(ContextMenuItem || (ContextMenuItem = {}));
            ;

            var CodeTokenCategory;
            (function (CodeTokenCategory) {
                CodeTokenCategory[CodeTokenCategory["Type"] = 0] = "Type";
                CodeTokenCategory[CodeTokenCategory["Field"] = 1] = "Field";
            })(CodeTokenCategory || (CodeTokenCategory = {}));

            var FeatureState;
            (function (FeatureState) {
                FeatureState[FeatureState["NotAvailable"] = 0] = "NotAvailable";
                FeatureState[FeatureState["Disabled"] = 1] = "Disabled";
                FeatureState[FeatureState["Enabled"] = 2] = "Enabled";
            })(FeatureState || (FeatureState = {}));

            var ProxyArrayWithAsyncPayload = (function (_super) {
                __extends(ProxyArrayWithAsyncPayload, _super);
                function ProxyArrayWithAsyncPayload(adaptor, gate, cacheSize) {
                    var _this = this;
                    _super.call(this, adaptor, gate, cacheSize);
                    this.adaptor().addEventListener(gate + "AsyncComplete", function (reply) {
                        return _this.onAsyncData(reply.Result);
                    });
                }
                ProxyArrayWithAsyncPayload.prototype.flushCache = function () {
                    this._mergedResultsStorage = {};
                    this._asyncResultsStorage = {};
                    this._asyncResultsNotReceived = {};
                    _super.prototype.flushCache.call(this);
                };

                ProxyArrayWithAsyncPayload.prototype.registerAsyncResultCallback = function (callback) {
                    this._asyncResultCallback = callback;
                };

                ProxyArrayWithAsyncPayload.prototype.get = function (index, func) {
                    var _this = this;
                    _super.prototype.get.call(this, index, function (value, needUpdate) {
                        if (_this._mergedResultsStorage[index]) {
                            func(_this._mergedResultsStorage[index], false);
                        } else {
                            if (value && value["Async"]) {
                                if (_this._asyncResultsStorage[index]) {
                                    value = _this._mergedResultsStorage[index] = _this.mergeObjects(value, _this._asyncResultsStorage[index]);
                                    delete _this._asyncResultsStorage[index];
                                } else {
                                    _this._asyncResultsNotReceived[index] = value;
                                }
                            }
                            func(value, needUpdate);
                        }
                    });
                };

                ProxyArrayWithAsyncPayload.prototype.onAsyncData = function (asyncResults) {
                    var _this = this;
                    asyncResults.forEach(function (asyncResult) {
                        var index = asyncResult["AsyncIndex"];

                        var value = _this._asyncResultsNotReceived[index];
                        if (!value) {
                            _this._asyncResultsStorage[index] = asyncResult;
                        } else {
                            _this._mergedResultsStorage[index] = _this.mergeObjects(value, asyncResult);
                            delete _this._asyncResultsNotReceived[index];

                            if (_this._asyncResultCallback) {
                                _this._asyncResultCallback(index, value);
                            }
                        }
                    });
                };

                ProxyArrayWithAsyncPayload.prototype.mergeObjects = function (to, from) {
                    for (var property in to) {
                        if (to.hasOwnProperty(property) && from.hasOwnProperty(property)) {
                            to[property] = from[property];
                        }
                    }
                    return to;
                };
                return ProxyArrayWithAsyncPayload;
            })(Common.Controls.DynamicGrid.ProxyArray);

            var MemoryAnalyzerViewer = (function () {
                function MemoryAnalyzerViewer() {
                    var _this = this;
                    this._refsViewerCache = [null, null];
                    this._typeRefsViewerCache = [null, null];
                    Plugin.Tooltip.defaultTooltipContentToHTML = false;

                    this._adaptor = Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.VisualStudio.Debugger.ManagedMemorySnapshotDetailViewModelMarshaler", {}, true);

                    document.addEventListener("keydown", function (e) {
                        if (e.keyCode === 112 /* F1 */) {
                            _this._adaptor._call("ShowHelp");
                            e.preventDefault();
                            e.stopPropagation();
                            return false;
                        }
                    });

                    window.addEventListener("focus", function (e) {
                        _this._adaptor._call("OnWindowActivated");
                    });

                    window.addEventListener("click", function (e) {
                        _this._adaptor._call("OnWindowActivated");
                    });

                    document.addEventListener("keydown", function (e) {
                        var target = e.target;
                        if (target && target.tagName != "INPUT") {
                            if (_this._viewType === 1 /* ObjectsView */ && e.keyCode === 8 /* BACKSPACE */) {
                                _this.setViewType(0 /* TypesView */, null);
                            }
                        }
                    });

                    this._adaptor.addEventListener("ideBFNavigate", function (navigateTo) {
                        _this.setViewType(navigateTo.Type, navigateTo.Title);
                    });

                    this.setViewType(0 /* TypesView */, null);
                    this._refGraphDirection = 1 /* Backward */;
                    this._adaptor._call("ChangeGraphDirection", this._refGraphDirection);
                    this.updateRefGraphDirectionUIElements(false);

                    this._justMyCode = false;
                    this._collapseSmallObjects = false;

                    this.diffCompleteEventAsync = this.diffCompleteEventAsync.bind(this);

                    var NUMERIC_COLUMN_WIDTH = 150;
                    var TAG_COLUMN_WIDTH = 500;

                    this._typeColumns = [
                        new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Type"), Plugin.Resources.getString("TypeTooltip"), TAG_COLUMN_WIDTH, true),
                        new Common.Controls.Grid.ColumnInfo("Count", Plugin.Resources.getString("Count"), Plugin.Resources.getString("CountTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("TotalSize", Plugin.Resources.getString("TotalSize"), Plugin.Resources.getString("SizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("RetainedSize", Plugin.Resources.getString("RetainedSize"), Plugin.Resources.getString("RetainedSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc")
                    ];

                    this._instanceColumns = [
                        new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Instance"), Plugin.Resources.getString("InstanceTooltip"), NUMERIC_COLUMN_WIDTH, true),
                        new Common.Controls.Grid.ColumnInfo("Value", Plugin.Resources.getString("Value"), Plugin.Resources.getString("ValueTooltip"), TAG_COLUMN_WIDTH, false),
                        new Common.Controls.Grid.ColumnInfo("TotalSize", Plugin.Resources.getString("InstanceSize"), Plugin.Resources.getString("InstanceSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("RetainedSize", Plugin.Resources.getString("RetainedSize"), Plugin.Resources.getString("InstanceRetainedSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc")
                    ];

                    var objectBackwardRefGraphTagColumnInfo = new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Instance"), Plugin.Resources.getString("InstanceTooltip"), TAG_COLUMN_WIDTH, false);

                    objectBackwardRefGraphTagColumnInfo.fixed = true;

                    this._objectBackwardRefGraphColumns = [
                        objectBackwardRefGraphTagColumnInfo
                    ];

                    var objectForwardRefGraphTagColumnInfo = new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Instance"), Plugin.Resources.getString("InstanceTooltip"), TAG_COLUMN_WIDTH, false);

                    objectForwardRefGraphTagColumnInfo.getHeaderCellContents = function () {
                        return _this.drawForwardReferenceGraphHeaderCell("Instance");
                    };

                    this._objectForwardRefGraphColumns = [
                        objectForwardRefGraphTagColumnInfo,
                        new Common.Controls.Grid.ColumnInfo("TotalSize", Plugin.Resources.getString("InstanceSize"), Plugin.Resources.getString("InstanceSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("RetainedSize", Plugin.Resources.getString("RetainedSize"), Plugin.Resources.getString("InstanceRetainedSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc")
                    ];

                    this._typeBackwardRefGraphColumns = [
                        new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Type"), Plugin.Resources.getString("TypeTooltip"), TAG_COLUMN_WIDTH, false),
                        new Common.Controls.Grid.ColumnInfo("RetainedCount", Plugin.Resources.getString("TypeRefGraphRetainedCountColumn"), Plugin.Resources.getString("TypeRefGraphRetainedCountColumnTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc")
                    ];

                    var typeTagColumnInfo = new Common.Controls.Grid.ColumnInfo("TagName", Plugin.Resources.getString("Type"), Plugin.Resources.getString("TypeTooltip"), TAG_COLUMN_WIDTH, false);

                    typeTagColumnInfo.getHeaderCellContents = function () {
                        return _this.drawForwardReferenceGraphHeaderCell("Type");
                    };

                    this._typeForwardRefGraphColumns = [
                        typeTagColumnInfo,
                        new Common.Controls.Grid.ColumnInfo("RefCount", Plugin.Resources.getString("TypeRefGraphRetainedCountColumn"), Plugin.Resources.getString("TypeRefGraphRetainedCountColumnTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("TotalSize", Plugin.Resources.getString("TotalSize"), Plugin.Resources.getString("SizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc"),
                        new Common.Controls.Grid.ColumnInfo("RetainedSize", Plugin.Resources.getString("RetainedSize"), Plugin.Resources.getString("RetainedSizeTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                            return "rightAlignedColumn";
                        }, null, "desc")
                    ];

                    this._adaptor.addEventListener("diffComplete", this.diffCompleteEventAsync);

                    this._adaptor.addEventListener("heapViewBroadcastEvent", function (eventArgs) {
                        switch (eventArgs.Type) {
                            case 2 /* VIEW_FILTER_CHANGED */:
                                _this._adaptor._call("GetDefaultViewSettings").done(function (options) {
                                    var myViewHasBeenUpdated = _this._justMyCode === options["JustMyCode"] && _this._collapseSmallObjects === options["CollapseSmallObjects"];
                                    if (!myViewHasBeenUpdated) {
                                        _this._justMyCode = options["JustMyCode"];
                                        _this._collapseSmallObjects = options["CollapseSmallObjects"];
                                        _this.applyViewFilter();
                                    }
                                });
                                break;
                            case 0 /* ANALYSIS_COMPLETE_SUCCESS */:
                            case 3 /* ANALYSIS_ERROR */:
                                _this.refreshDropDownAsync();
                            case 1 /* SNAPSHOT_DESTROY */:
                                break;
                            default:
                                throw Error("wrong event type");
                        }
                    });

                    this._adaptor._call("DiffSnapshotId").done(function (result) {
                        if (result) {
                            var COUNT_DIFF_COLUMN_INDEX = 2;
                            var TOTALSIZE_DIFF_COLUMN_INDEX = 4;
                            var RETAINEDSIZE_DIFF_COLUMN_INDEX = 6;

                            _this._typeColumns.splice(COUNT_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("CountDiff", Plugin.Resources.getString("CountDiff"), Plugin.Resources.getString("CountDiffTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeColumns.splice(TOTALSIZE_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("TotalSizeDiff", Plugin.Resources.getString("TotalSizeDiff"), Plugin.Resources.getString("TotalSizeDiffTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeColumns.splice(RETAINEDSIZE_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("RetainedSizeDiff", Plugin.Resources.getString("RetainedSizeDiff"), Plugin.Resources.getString("RetainedSizeDiffTooltip"), NUMERIC_COLUMN_WIDTH + 11, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeBackwardRefGraphColumns.push(new Common.Controls.Grid.ColumnInfo("RetainedCountDiff", Plugin.Resources.getString("TypeRefGraphRetainedCountDiffColumn"), Plugin.Resources.getString("TypeRefGraphRetainedCountDiffColumnTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeForwardRefGraphColumns.splice(COUNT_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("RefCountDiff", Plugin.Resources.getString("TypeRefGraphRetainedCountDiffColumn"), Plugin.Resources.getString("TypeRefGraphRetainedCountDiffColumnTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeForwardRefGraphColumns.splice(TOTALSIZE_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("TotalSizeDiff", Plugin.Resources.getString("TotalSizeDiff"), Plugin.Resources.getString("TotalSizeDiffTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._typeForwardRefGraphColumns.splice(RETAINEDSIZE_DIFF_COLUMN_INDEX, 0, new Common.Controls.Grid.ColumnInfo("RetainedSizeDiff", Plugin.Resources.getString("RetainedSizeDiff"), Plugin.Resources.getString("RetainedSizeDiffTooltip"), NUMERIC_COLUMN_WIDTH, true, null, function () {
                                return "rightAlignedColumn";
                            }, null, "desc"));

                            _this._activeDropDownName = result;
                        }

                        _this.initializeContextMenus();
                        _this.initializeUIElementsAsync();
                        _this.refreshUIAsync();
                    });
                }
                MemoryAnalyzerViewer.copySelectedRowToClipboard = function (menuId, menuItem, targetId) {
                    if (MemoryAnalyzerViewer.dataForClipboard)
                        window.clipboardData.setData('Text', MemoryAnalyzerViewer.dataForClipboard);
                };

                MemoryAnalyzerViewer.prototype.diffCompleteEventAsync = function (eventArgs) {
                    if (eventArgs.Type === 0 /* SUCCESS */) {
                        this._adaptor.removeEventListener("diffCompleteEvent", this.diffCompleteEventAsync);

                        window.location.reload();
                    } else {
                        this._diffDropDown.disabled = false;
                        this.refreshDropDownAsync();
                    }
                };

                MemoryAnalyzerViewer.prototype.initializeViewSettingsMenu = function () {
                    var _this = this;
                    var menuItems = new Array();
                    menuItems[0] = {
                        id: "menuJustMyCode",
                        callback: function () {
                            _this.toggleJustMyCodeAsync();
                        },
                        label: Plugin.Resources.getString("ViewSettingsJustMyCodeMenuItem"),
                        type: 0 /* checkbox */,
                        iconEnabled: null,
                        iconDisabled: null,
                        accessKey: null,
                        hidden: function () {
                            return false;
                        },
                        disabled: function () {
                            return false;
                        },
                        checked: function () {
                            return _this._justMyCode;
                        },
                        cssClass: null,
                        submenu: null
                    };

                    menuItems[1] = {
                        id: "menuCollapseSmallObjects",
                        callback: function () {
                            _this.toggleCollapseSmallObjectsAsync();
                        },
                        label: Plugin.Resources.getString("ViewSettingsCollapseSmallObjectsMenuItem"),
                        type: 0 /* checkbox */,
                        iconEnabled: null,
                        iconDisabled: null,
                        accessKey: null,
                        hidden: function () {
                            return false;
                        },
                        disabled: function () {
                            return false;
                        },
                        checked: function () {
                            return _this._collapseSmallObjects;
                        },
                        cssClass: null,
                        submenu: null
                    };

                    this._viewSettingsMenu = Plugin.ContextMenu.create(menuItems);
                };

                MemoryAnalyzerViewer.prototype.toggleJustMyCodeAsync = function () {
                    this._justMyCode = !this._justMyCode;
                    this.applyViewFilter();
                };

                MemoryAnalyzerViewer.prototype.toggleCollapseSmallObjectsAsync = function () {
                    this._collapseSmallObjects = !this._collapseSmallObjects;
                    this.applyViewFilter();
                };

                MemoryAnalyzerViewer.prototype.applyViewFilter = function () {
                    var _this = this;
                    this._typesViewer.setDirty(true);
                    this._objectsViewer.setDirty(true);
                    this._adaptor._call("ApplyViewFilter", this._justMyCode, this._collapseSmallObjects).done(function () {
                        _this.updateNotificationBar();
                        _this._typesViewer.resetView();
                        _this._objectsViewer.resetView();
                    });
                };

                MemoryAnalyzerViewer.prototype.updateNotificationBar = function () {
                    if (this._justMyCode || this._collapseSmallObjects) {
                        this._notificationBar.style.display = "block";

                        var activeSettingName = "";

                        if (this._justMyCode) {
                            activeSettingName = Plugin.Resources.getString("NotificationBarJMCEnabled");
                        }

                        if (this._collapseSmallObjects) {
                            if (this._justMyCode) {
                                activeSettingName = activeSettingName.concat(", ");
                            }

                            activeSettingName = activeSettingName.concat(Plugin.Resources.getString("NotificationBarCollapseSmallObjectsEnabled"));
                        }

                        this._notificationBarMessage.innerText = Plugin.Resources.getString("NotificationBarMessage").replace("{0}", activeSettingName);
                    } else {
                        this._notificationBar.style.display = "none";
                    }
                };

                MemoryAnalyzerViewer.prototype.initializeContextMenus = function () {
                    this.initializeViewSettingsMenu();
                    this._gridContextMenuOptions = new Array();

                    for (var menu = 0; menu <= ContextMenuType.Last; menu++) {
                        var menuItems = new Array();

                        menuItems[0 /* Copy */] = {
                            id: "menuItem0" + menu,
                            callback: MemoryAnalyzerViewer.copySelectedRowToClipboard,
                            label: Plugin.Resources.getString("ContextMenuCopy"),
                            type: 1 /* command */,
                            iconEnabled: "vs-image-menu-copy-enabled",
                            iconDisabled: "vs-image-menu-copy-disabled",
                            accessKey: "Ctrl+C",
                            hidden: function () {
                                return false;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[1 /* Separator1 */] = {
                            id: "menuItem1" + menu,
                            callback: function () {
                            },
                            label: null,
                            type: 3 /* separator */,
                            iconEnabled: null,
                            iconDisabled: null,
                            accessKey: null,
                            hidden: function () {
                                return true;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[2 /* AddWatch */] = {
                            id: "menuItem2" + menu,
                            callback: function () {
                            },
                            label: Plugin.Resources.getString("ContextMenuAddWatch"),
                            type: 1 /* command */,
                            iconEnabled: "vs-mma-watch",
                            iconDisabled: "vs-mma-watch",
                            accessKey: null,
                            hidden: function () {
                                return true;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[4 /* ViewInstances */] = {
                            id: "menuItem3" + menu,
                            callback: function () {
                            },
                            label: Plugin.Resources.getString("ContextMenuViewInstances"),
                            type: 1 /* command */,
                            iconEnabled: "vs-mma-inspect",
                            iconDisabled: "vs-mma-inspect",
                            accessKey: null,
                            hidden: function () {
                                return true;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[3 /* QuickWatch */] = {
                            id: "menuItem4" + menu,
                            callback: function () {
                            },
                            label: Plugin.Resources.getString("ContextMenuQuickWatch"),
                            type: 1 /* command */,
                            iconEnabled: "vs-mma-watch",
                            iconDisabled: "vs-mma-watch",
                            accessKey: null,
                            hidden: function () {
                                return true;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[5 /* Separator2 */] = {
                            id: "menuItem5" + menu,
                            callback: function () {
                            },
                            label: null,
                            type: 3 /* separator */,
                            iconEnabled: null,
                            iconDisabled: null,
                            accessKey: null,
                            hidden: function () {
                                return false;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[6 /* GoToDefinition */] = {
                            id: "menuItem6" + menu,
                            callback: function () {
                            },
                            label: Plugin.Resources.getString("ContextMenuGoToDefinition"),
                            type: 1 /* command */,
                            iconEnabled: null,
                            iconDisabled: null,
                            accessKey: "F12",
                            hidden: function () {
                                return false;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        menuItems[7 /* FindAllReferences */] = {
                            id: "menuItem7" + menu,
                            callback: function () {
                            },
                            label: Plugin.Resources.getString("ContextMenuFindAllReferences"),
                            type: 1 /* command */,
                            iconEnabled: null,
                            iconDisabled: null,
                            accessKey: "Shift+F12",
                            hidden: function () {
                                return false;
                            },
                            disabled: function () {
                                return false;
                            },
                            checked: function () {
                                return false;
                            },
                            cssClass: null,
                            submenu: null
                        };

                        this._gridContextMenuOptions[menu] = menuItems;
                    }
                };

                MemoryAnalyzerViewer.prototype.initializeUIElementsAsync = function () {
                    var _this = this;
                    this._adaptor._call("GetSnapshotId").done(function (result) {
                        _this._snapshotId = result;

                        _this._filter = document.getElementById("filterInput");

                        _this._filter.placeholder = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("Filter"));
                        var compareToCaptionElement = document.getElementById("compareToCaption");
                        compareToCaptionElement.innerHTML = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("CompareToCaption"));

                        _this._adaptor._call("ProcessName").done(function (pname) {
                            var headerLabel;
                            if (pname) {
                                var splitPosition = pname.indexOf(':');
                                pname = splitPosition > 0 ? pname.substr(0, splitPosition - 1) : pname;
                                headerLabel = Plugin.Resources.getString("ManagedMemoryLabelWithProcessName").replace("{0}", pname);
                            } else
                                headerLabel = Plugin.Resources.getString("ManagedMemoryLabel");

                            headerLabel = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(headerLabel);

                            var viewGeneralCaptionSpan = document.getElementById("viewGeneralCaption");
                            var viewGeneralCaptionContainerDiv = document.getElementById("viewGeneralCaptionContainer");

                            viewGeneralCaptionSpan.innerHTML = headerLabel;
                            if (viewGeneralCaptionContainerDiv.scrollWidth > viewGeneralCaptionContainerDiv.offsetWidth)
                                viewGeneralCaptionSpan.title = headerLabel;
                        });

                        _this._filter.onkeypress = function (e) {
                            if (_this._filter.value) {
                                _this._filter.placeholder = "";
                            }
                            if (e.keyCode == 13 /* ENTER */) {
                                _this.getActiveView().setFilterAsync(_this._filter.value);
                            } else if (e.keyCode === 27 /* ESCAPE */) {
                                _this._filter.value = "";
                                _this.getActiveView().setFilterAsync("");
                                _this._filter.placeholder = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("Filter"));
                            }
                        };

                        _this._filter.oninput = function (e) {
                            if (_this._filter.value === "" && _this._filter.placeholder === "") {
                                _this.getActiveView().setFilterAsync(_this._filter.value);
                                _this._filter.placeholder = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("Filter"));
                            }
                        };

                        var viewSettingsHyperlinkName = document.getElementById("viewSettingsMenuLinkName");
                        viewSettingsHyperlinkName.innerText = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("ViewSettingsMenuCaption"));

                        _this._viewSettingsHyperlink = document.getElementById("viewSettingsMenu");
                        _this._viewSettingsHyperlink.addEventListener("click", function () {
                            _this._viewSettingsMenuClicked = true;

                            setTimeout(function () {
                                _this.showViewSettingsContextMenu();
                            }, 0);
                        });

                        _this._viewSettingsHyperlink.addEventListener("keydown", function (e) {
                            if ((e.keyCode === 13 /* ENTER */) || (e.keyCode === 121 /* F10 */ && e.shiftKey) || (e.keyCode === 93 /* MENU */)) {
                                _this.showViewSettingsContextMenu();
                                return false;
                            }

                            return true;
                        });

                        _this._viewSettingsHyperlink.onfocus = function () {
                            if (_this._viewSettingsMenuClicked) {
                                _this._viewSettingsHyperlink.style.outline = "none";
                                _this._viewSettingsMenuClicked = false;
                            } else {
                                _this._viewSettingsHyperlink.style.outline = "";
                            }
                        };

                        _this._notificationBar = document.getElementById("notificationBar");
                        _this._notificationBarMessage = document.getElementById("notificationBarMessage");
                        _this._diffDropDown = document.getElementById("diffDropDown");

                        _this._diffDropDown.onchange = function (e) {
                            if (_this._diffDropDown.selectedIndex > 0) {
                                if (_this._diffDropDown.value === "Browse") {
                                    _this._adaptor._call("Browse").done(function (result) {
                                        if (result && result !== _this._activeDropDownName) {
                                            _this.diffAgainstAsync(result);
                                        } else {
                                            _this.refreshDropDownAsync();
                                        }
                                    });
                                } else {
                                    _this.diffAgainstAsync(_this._diffDropDown.value);
                                }
                            } else if (_this._diffDropDown.selectedIndex === 0) {
                                _this._activeDropDownName = "";
                                _this._adaptor._call("CompareWithNone").done(function () {
                                    window.location.reload();
                                });
                            }
                        };
                        _this.refreshDropDownAsync();
                    });
                };

                MemoryAnalyzerViewer.prototype.showViewSettingsContextMenu = function () {
                    var rect = this._viewSettingsHyperlink.getBoundingClientRect();
                    if (this._viewSettingsMenu) {
                        this._viewSettingsMenu.show(rect.left, rect.bottom);
                    }
                };

                MemoryAnalyzerViewer.prototype.drawForwardReferenceGraphHeaderCell = function (columnTitleResourceName) {
                    var cellElement = document.createElement("div");
                    cellElement.classList.add("title");

                    if (this._justMyCode || this._collapseSmallObjects) {
                        var infoIconHtml = "<span title='{0}' class='icon-information'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>";
                        infoIconHtml = infoIconHtml.replace("{0}", Plugin.Resources.getString("ReferencesViewNoViewMessage"));
                        cellElement.innerHTML = Plugin.Resources.getString(columnTitleResourceName) + infoIconHtml;
                    } else {
                        cellElement.innerText = Plugin.Resources.getString(columnTitleResourceName);
                    }

                    return cellElement;
                };

                MemoryAnalyzerViewer.prototype.diffAgainstAsync = function (diffName, hideWarning) {
                    var _this = this;
                    if (typeof hideWarning === "undefined") { hideWarning = false; }
                    this._diffDropDown.disabled = true;

                    this._adaptor._call("StartManagedMemoryAnalysisAndDiff", diffName).done(function (result) {
                        if (!result) {
                            _this._diffDropDown.disabled = false;
                            _this.refreshDropDownAsync();
                        } else {
                        }
                    });
                };

                MemoryAnalyzerViewer.prototype.refreshUIAsync = function () {
                    var _this = this;
                    if (this._typesViewer)
                        this._typesViewer = null;
                    if (this._splitter)
                        this._splitter = null;

                    var div = document.querySelector("#managedHeapTypesViewerContainer");
                    while (div.firstChild) {
                        div.removeChild(div.firstChild);
                    }

                    if (this._typesDataSource) {
                        this._typesDataSource.flushCache();
                        this._typesDataSource = null;
                    }

                    if (this._objectsDataSource) {
                        this._objectsDataSource.flushCache();
                        this._objectsDataSource = null;
                    }

                    this._typesDataSource = new Common.Controls.DynamicGrid.ProxyArray(this._adaptor, "TypeSummaries", MemoryAnalyzerViewer.ProxyArrayCacheSize);
                    this._objectsDataSource = new ProxyArrayWithAsyncPayload(this._adaptor, "ObjectSummaries", MemoryAnalyzerViewer.ProxyArrayCacheSize);

                    this._adaptor._call("GetDefaultViewSettings").done(function (options) {
                        _this.setRefGraphDirectionAsync(_this._refGraphDirection, function () {
                            _this._typesDataSource.init(function () {
                                _this._typesViewer = new MemoryAnalyzerTypesGridViewer(document.querySelector("#managedHeapTypesViewerContainer"), _this._typesDataSource, _this._gridContextMenuOptions[0 /* Types */], _this._typeColumns, function (showTypeRefGraph) {
                                    if (showTypeRefGraph) {
                                        _this._typeRefsViewer.refresh();
                                        _this._typeRefsViewer.expandRoot();
                                    }
                                    _this.updateRefGraphDirectionUIElements(showTypeRefGraph);
                                    _this._typeRefsViewer.showGraph(showTypeRefGraph);
                                }, function (path, rowData, typeName) {
                                    _this._objectsViewer.setCurrentTypeAsync(rowData.Tag);
                                    _this.setViewType(1 /* ObjectsView */, typeName);
                                }, options["SnapshotType"]);

                                _this._objectsViewer = new MemoryAnalyzerObjectsGridViewer(document.querySelector("#managedHeapObjectsViewerContainer"), _this._objectsDataSource, _this._gridContextMenuOptions[1 /* Objects */], _this._instanceColumns, function (showRefGraph) {
                                    if (showRefGraph) {
                                        _this._refsViewer.refresh();
                                        _this._refsViewer.expandRoot();
                                    }
                                    _this.updateRefGraphDirectionUIElements(showRefGraph);
                                    _this._refsViewer.showGraph(showRefGraph);
                                }, options["NumberOfObjectsPerType"]);

                                _this._justMyCode = options["JustMyCode"];
                                _this._collapseSmallObjects = options["CollapseSmallObjects"];
                                _this.updateNotificationBar();

                                _this._splitter = new HeapViewer.HorizontalSplitter(document.getElementById("splitter"), 0.6, function () {
                                    if (_this._viewType === 0 /* TypesView */) {
                                        _this._typesViewer.scheduleUpdate();
                                        _this._typeRefsViewer.scheduleUpdate();
                                    } else {
                                        _this._objectsViewer.scheduleUpdate();
                                        _this._refsViewer.scheduleUpdate();
                                    }
                                });
                            });
                        });
                    });

                    this.showSamplingIconAsync();
                };

                MemoryAnalyzerViewer.prototype.refreshDropDownAsync = function () {
                    var _this = this;
                    if (this._diffDropDown.disabled)
                        return;

                    this._adaptor._call("OtherActiveMemoryAnalysisInstanceNames").done(function (result) {
                        _this._diffDropDownTitleElement = new Option(Plugin.Resources.getString("SelectDefault"), "0");

                        _this._diffDropDown.options.length = 0;
                        _this._diffDropDown.options.add(_this._diffDropDownTitleElement);

                        var index = 0;

                        for (var key in result) {
                            if (result.hasOwnProperty(key)) {
                                var optionText = (MemoryAnalyzer.FormattingHelpers.getNativeDigitLocaleString(MemoryAnalyzer.FormattingHelpers.trimLongString(result[key])));

                                _this._diffDropDown.options.add(new Option(optionText, key));
                                if (_this._activeDropDownName === key)
                                    index = _this._diffDropDown.options.length - 1;
                            }
                        }

                        _this._diffDropDown.options.add(new Option(Plugin.Resources.getString("SelectBrowse"), "Browse"));

                        if (_this._activeDropDownName) {
                            _this._diffDropDownTitleElement.innerText = Plugin.Resources.getString("SelectDefaultNone");

                            if (_this._diffDropDown.classList.contains("disabledColor"))
                                _this._diffDropDown.classList.remove("disabledColor");
                        } else {
                            if (!_this._diffDropDown.classList.contains("disabledColor"))
                                _this._diffDropDown.classList.add("disabledColor");
                        }

                        _this._diffDropDown.selectedIndex = index;
                    });
                };

                MemoryAnalyzerViewer.prototype.showSamplingIconAsync = function () {
                    var _this = this;
                    this._adaptor._call("IsSamplingEnabled").done(function (result) {
                        if (result) {
                            var samplingIconHtml = "<span class='icon-information'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>";

                            var countColumn = _this._typeColumns[1];
                            if (countColumn.index !== "Count") {
                                throw Error("incorrect column");
                            }
                            countColumn.hasHTMLContent = true;
                            countColumn.text += samplingIconHtml;
                            countColumn.tooltip = Plugin.Resources.getString("SamplingEnabledTooltip");

                            countColumn = _this.getTypeRefGraphColumns()[1];
                            if (countColumn.index !== "RetainedCount" && countColumn.index !== "RefCount") {
                                throw Error("incorrect column");
                            }
                            countColumn.hasHTMLContent = true;
                            countColumn.text += samplingIconHtml;
                            countColumn.tooltip = Plugin.Resources.getString("SamplingEnabledTooltip");
                        }
                    });
                };

                MemoryAnalyzerViewer.prototype.setViewType = function (inspectionType, title) {
                    var viewerDomElement = [];
                    viewerDomElement[0 /* TypesView */] = document.querySelector("#managedHeapTypesViewerContainer");
                    viewerDomElement[1 /* ObjectsView */] = document.querySelector("#managedHeapObjectsViewerContainer");
                    var viewSettings = document.querySelector("#viewSettingsMenu");
                    var diffDropDownCaption = document.querySelector("#compareToCaption");
                    var diffDropDown = document.querySelector("#diffDropDown");
                    var refGraphNoData = document.querySelector("#managedHeapViewerRefGraphNoData");

                    refGraphNoData.innerHTML = Plugin.Resources.getString(inspectionType === 0 /* TypesView */ ? "TypeRefGraphNoData" : "ObjectRefGraphNoData");

                    if (inspectionType === 0 /* TypesView */) {
                        viewerDomElement[0 /* TypesView */].style.display = "";
                        viewerDomElement[1 /* ObjectsView */].style.display = "none";

                        diffDropDownCaption.style.display = diffDropDown.style.display = viewSettings.style.display = "";

                        if (this._objectsViewer) {
                            this._objectsViewer.tryToCloseDataTip(true);
                            this._objectsViewer.showRefGraph(false);
                            this._objectsViewer.resetView();
                            this._objectsViewer.clearFilter();
                        }
                        if (this._typesViewer) {
                            this._typesViewer.showRefGraph(false);
                            this._typesViewer.resetFilter();
                            this._typesViewer.clearCurrentSelection();
                            this._typesViewer.scheduleUpdate();
                        }
                    } else {
                        viewerDomElement[0 /* TypesView */].style.display = "none";
                        viewerDomElement[1 /* ObjectsView */].style.display = "";

                        diffDropDownCaption.style.display = diffDropDown.style.display = viewSettings.style.display = "none";

                        if (this._typesViewer) {
                            this._typesViewer.showRefGraph(false);
                        }
                        if (this._objectsViewer) {
                            this._objectsViewer.showRefGraph(false);
                            this._objectsViewer.resetFilter();
                            this._objectsViewer.scheduleUpdate();
                        }
                    }
                    this._viewType = inspectionType;
                    this.updateBreadCrumb(title);
                };

                MemoryAnalyzerViewer.prototype.updateBreadCrumb = function (title) {
                    var _this = this;
                    var breadCrumb = document.querySelector("#navigationBreadCrumb");

                    while (breadCrumb.firstChild)
                        breadCrumb.removeChild(breadCrumb.firstChild);

                    if (this._viewType === 1 /* ObjectsView */) {
                        var gotoTypesLink = document.createElement("a");
                        gotoTypesLink.innerText = Plugin.Resources.getString("BreadCrumbType");
                        gotoTypesLink.tabIndex = 0;

                        gotoTypesLink.addEventListener("click", function (e) {
                            _this.setViewType(0 /* TypesView */, null);
                        });

                        gotoTypesLink.addEventListener("keydown", function (e) {
                            if (e.keyCode === 13 /* ENTER */) {
                                _this.setViewType(0 /* TypesView */, null);
                            }
                        });

                        breadCrumb.appendChild(gotoTypesLink);
                        var text = document.createElement("span");

                        var separator = "&nbsp;&nbsp;<b>&#9654;</b>&nbsp;&nbsp;";
                        var instancesOfText = Plugin.Resources.getString("InstancesOfHeader").replace("{0}", title);
                        text.innerHTML = separator + MemoryAnalyzer.FormattingHelpers.forceHtmlRendering(instancesOfText);
                        breadCrumb.appendChild(text);
                    }

                    this._adaptor._call("RegisterIDENavigationPoint", this._viewType, this._viewType === 0 /* TypesView */ ? Plugin.Resources.getString("BreadCrumbType") : title);
                };

                MemoryAnalyzerViewer.prototype.setRefGraphDirectionAsync = function (direction, done) {
                    var _this = this;
                    this._refGraphDirection = direction;

                    this._adaptor._call("ChangeGraphDirection", this._refGraphDirection).done(function () {
                        var refGraphDom = document.querySelector(direction === 0 /* Forward */ ? "#managedHeapViewerForwardRefGraphContainer" : "#managedHeapViewerBackwardRefGraphContainer");
                        var typeRefGraphDom = document.querySelector(direction === 0 /* Forward */ ? "#managedHeapViewerForwardTypeRefGraphContainer" : "#managedHeapViewerBackwardTypeRefGraphContainer");
                        var oppositeRefGraphDom = document.querySelector(direction === 1 /* Backward */ ? "#managedHeapViewerForwardRefGraphContainer" : "#managedHeapViewerBackwardRefGraphContainer");
                        var oppositeTypeRefGraphDom = document.querySelector(direction === 1 /* Backward */ ? "#managedHeapViewerForwardTypeRefGraphContainer" : "#managedHeapViewerBackwardTypeRefGraphContainer");

                        if (_this._viewType === 1 /* ObjectsView */) {
                            refGraphDom.style.display = "block";
                        } else if (_this._viewType === 0 /* TypesView */) {
                            typeRefGraphDom.style.display = "block";
                        }

                        oppositeRefGraphDom.style.display = oppositeTypeRefGraphDom.style.display = "none";

                        var div = document.querySelector("#managedHeapViewerRefGraphNoData");
                        div.style.display = "none";

                        var refGraphIsAlreadyInCache = false;

                        if (_this._refsViewerCache[_this._refGraphDirection]) {
                            _this._refsViewer = _this._refsViewerCache[_this._refGraphDirection];
                            refGraphIsAlreadyInCache = true;
                        } else {
                            var refGraphDataArray = new Common.Controls.DynamicGrid.ProxyArray(_this._adaptor, _this.getObjectRefGraphDataSource(), MemoryAnalyzerViewer.ProxyArrayCacheSize);
                            refGraphDataArray.init(function () {
                                var contextMenu = _this._gridContextMenuOptions[direction === 0 /* Forward */ ? 3 /* ForwardRefGraph */ : 2 /* BackwardRefGraph */];
                                _this._refsViewerCache[_this._refGraphDirection] = _this._refsViewer = new MemoryAnalyzerRefGraphViewer(refGraphDom, refGraphDataArray, contextMenu, _this.getObjectRefGraphColumns(), _this._refGraphDirection);

                                if (_this._viewType === 1 /* ObjectsView */) {
                                    _this.updateRefGraphDirectionUIElements(false);

                                    _this._refsViewer.showGraph(true);
                                    if (_this._objectsViewer)
                                        _this._objectsViewer.reactivateCurrentRow();
                                }
                            });
                        }

                        if (_this._typeRefsViewerCache[_this._refGraphDirection]) {
                            _this._typeRefsViewer = _this._typeRefsViewerCache[_this._refGraphDirection];
                            refGraphIsAlreadyInCache = true;
                        } else {
                            var typeRefGraphDataArray = new Common.Controls.DynamicGrid.ProxyArray(_this._adaptor, _this.getTypeRefGraphDataSource(), MemoryAnalyzerViewer.ProxyArrayCacheSize);
                            typeRefGraphDataArray.init(function () {
                                var contextMenu = _this._gridContextMenuOptions[direction === 0 /* Forward */ ? 5 /* ForwardTypesRefGraph */ : 4 /* BackwardTypesRefGraph */];
                                _this._typeRefsViewerCache[_this._refGraphDirection] = _this._typeRefsViewer = new MemoryAnalyzerTypeRefGraphViewer(typeRefGraphDom, typeRefGraphDataArray, contextMenu, _this.getTypeRefGraphColumns(), _this._refGraphDirection);

                                if (_this._viewType === 0 /* TypesView */) {
                                    _this.updateRefGraphDirectionUIElements(false);

                                    _this._typeRefsViewer.showGraph(true);
                                    if (_this._typesViewer) {
                                        _this._typesViewer.reactivateCurrentRow();
                                    }
                                }
                            });
                        }

                        if (refGraphIsAlreadyInCache) {
                            _this.updateRefGraphDirectionUIElements(true);
                            _this._typeRefsViewer.refreshSortingOrder(function () {
                                var currentRowHasNotChanged = (_this._viewType === 0 /* TypesView */ && _this._typesViewer && _this._currentSelectedIndexBeforeSwitchingGraphDirection !== _this._typesViewer.getSelectedRowIndex()) || (_this._viewType === 1 /* ObjectsView */ && _this._objectsViewer && _this._currentSelectedIndexBeforeSwitchingGraphDirection !== _this._objectsViewer.getSelectedRowIndex());
                                if (currentRowHasNotChanged) {
                                    if (_this._viewType === 1 /* ObjectsView */)
                                        _this._objectsViewer.reactivateCurrentRow();
                                    if (_this._viewType === 0 /* TypesView */)
                                        _this._typesViewer.reactivateCurrentRow();
                                } else {
                                    if (_this._viewType === 1 /* ObjectsView */) {
                                        _this._refsViewer.scheduleUpdate();
                                    } else if (_this._viewType === 0 /* TypesView */) {
                                        _this._typeRefsViewer.scheduleUpdate();
                                    }
                                }

                                if (_this._typesViewer) {
                                    _this._currentSelectedIndexBeforeSwitchingGraphDirection = _this._typesViewer.getSelectedRowIndex();
                                }
                            });
                        } else {
                            _this._currentSelectedIndexBeforeSwitchingGraphDirection = _this._typesViewer ? _this._typesViewer.getSelectedRowIndex() : -1;
                        }

                        if (done) {
                            done();
                        }
                    });
                    return this._refGraphDirection;
                };

                MemoryAnalyzerViewer.prototype.resetCurrentSelectedIndex = function () {
                    this._currentSelectedIndexBeforeSwitchingGraphDirection = -1;
                    this.updateRefGraphDirectionUIElements(false);
                };

                MemoryAnalyzerViewer.prototype.updateRefGraphDirectionUIElements = function (showTabs) {
                    var _this = this;
                    var refGraphHeader = document.getElementById("refGraphHeader");
                    var referencingGraph = document.getElementById("referencingGraph");
                    var referencedGraph = document.getElementById("referencedGraph");

                    if (!showTabs) {
                        refGraphHeader.style.display = "none";
                    } else {
                        refGraphHeader.style.display = "block";

                        referencingGraph.innerText = Plugin.Resources.getString("ReferencingGraph");
                        referencingGraph.title = Plugin.Resources.getString(this._viewType === 0 /* TypesView */ ? "ReferencingGraphTypesTooltip" : "ReferencingGraphObjectsTooltip");

                        referencedGraph.innerText = Plugin.Resources.getString(this._viewType === 0 /* TypesView */ ? "ReferencedGraphTypes" : "ReferencedGraphObjects");
                        referencedGraph.title = Plugin.Resources.getString(this._viewType === 0 /* TypesView */ ? "ReferencedGraphTypesTooltip" : "ReferencedGraphObjectsTooltip");

                        if (this._refGraphDirection === 1 /* Backward */) {
                            referencingGraph.className = "disabled";
                            referencedGraph.className = "enabled";

                            referencingGraph.onclick = undefined;
                            referencedGraph.onclick = function (e) {
                                _this._adaptor._call(_this._viewType === 0 /* TypesView */ ? "OnSelectTypeRefGraph" : "OnSelectObjectRefGraph", 0 /* Forward */);

                                _this.setRefGraphDirectionAsync(0 /* Forward */);
                            };
                        } else {
                            referencingGraph.className = "enabled";
                            referencedGraph.className = "disabled";

                            referencedGraph.onclick = undefined;
                            referencingGraph.onclick = function (e) {
                                _this._adaptor._call(_this._viewType === 0 /* TypesView */ ? "OnSelectTypeRefGraph" : "OnSelectObjectRefGraph", 1 /* Backward */);

                                _this.setRefGraphDirectionAsync(1 /* Backward */);
                            };
                        }
                    }
                };

                MemoryAnalyzerViewer.prototype.getTypeRefGraphColumns = function () {
                    return this._refGraphDirection == 0 /* Forward */ ? this._typeForwardRefGraphColumns : this._typeBackwardRefGraphColumns;
                };

                MemoryAnalyzerViewer.prototype.getTypeRefGraphDataSource = function () {
                    return this._refGraphDirection == 0 /* Forward */ ? "TypeForwardRefGraph" : "TypeRefGraph";
                };

                MemoryAnalyzerViewer.prototype.getObjectRefGraphColumns = function () {
                    return this._refGraphDirection == 0 /* Forward */ ? this._objectForwardRefGraphColumns : this._objectBackwardRefGraphColumns;
                };

                MemoryAnalyzerViewer.prototype.getObjectRefGraphDataSource = function () {
                    return this._refGraphDirection == 0 /* Forward */ ? "ForwardRefGraph" : "RefGraph";
                };

                MemoryAnalyzerViewer.prototype.getActiveView = function () {
                    return this._viewType === 1 /* ObjectsView */ ? this._objectsViewer : this._typesViewer;
                };
                MemoryAnalyzerViewer.ProxyArrayCacheSize = 1000;
                return MemoryAnalyzerViewer;
            })();

            var MemoryAnalyzerGridViewer = (function (_super) {
                __extends(MemoryAnalyzerGridViewer, _super);
                function MemoryAnalyzerGridViewer(root, dataArray, gridContextMenu, columns, refGraphCallback, setFilterAndSortOrderHandler) {
                    this._dirtyFlag = false;

                    this._gridColumns = columns;
                    this._refGraphShowCallback = refGraphCallback;
                    this._setFilterAndSortOrderHandler = setFilterAndSortOrderHandler;

                    var options = new Common.Controls.DynamicGrid.DynamicGridViewerOptions(gridContextMenu, null, this._gridColumns, null);
                    options.overflowColumn = true;
                    options.focusable = true;

                    this._refGraphNoDataElement = document.getElementById("managedHeapViewerRefGraphNoData");
                    this.showRefGraphNoData(true);

                    this._filterDomElement = document.getElementById("filterInput");

                    _super.call(this, dataArray, root, options);

                    this.setDefaultSortOrder();
                }
                MemoryAnalyzerGridViewer.prototype.setDirty = function (dirty) {
                    this._dirtyFlag = dirty;
                };

                MemoryAnalyzerGridViewer.prototype.isDirty = function () {
                    return this._dirtyFlag;
                };

                MemoryAnalyzerGridViewer.prototype.resetView = function () {
                    this.refresh();
                    this._currentSelectedIndex = -1;
                    MemoryAnalyzerViewer.instance.resetCurrentSelectedIndex();

                    this.showRefGraph(false);
                    this._clearSelection();
                    this.setDirty(false);
                };

                MemoryAnalyzerGridViewer.prototype.setFilterAsync = function (filterString) {
                    var _this = this;
                    if (filterString !== this._filter) {
                        this._filter = filterString;
                        this.adaptor()._call(this._setFilterAndSortOrderHandler, this._filter, this._sortOrderIndex, this._sortOrderOrder).done(function (refresh) {
                            if (refresh) {
                                _this.resetView();
                            }
                        });
                    }

                    if (this.rootElement.style.display !== "none" && this._filterDomElement.value !== this._filter) {
                        this._filterDomElement.value = this._filter;
                        if (!this._filter || this._filter.length === 0) {
                            this._filterDomElement.value = "";
                            this._filterDomElement.placeholder = MemoryAnalyzer.FormattingHelpers.forceNonBreakingSpaces(Plugin.Resources.getString("Filter"));
                        }
                    }
                };

                MemoryAnalyzerGridViewer.prototype.resetFilter = function () {
                    this.setFilterAsync(this._filter);
                };

                MemoryAnalyzerGridViewer.prototype.clearFilter = function () {
                    this.setFilterAsync("");
                };

                MemoryAnalyzerGridViewer.prototype.clearCurrentSelection = function () {
                    this._currentSelectedIndex = -1;
                };

                MemoryAnalyzerGridViewer.prototype.onCtrlC = function () {
                    var dataIndex = this.getSelectedDataIndex();
                    var rowText = this.getRowTextString(dataIndex);

                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        MemoryAnalyzerViewer.copySelectedRowToClipboard(null, null, null);
                    }
                };

                MemoryAnalyzerGridViewer.prototype.initializeContextMenu = function (dataIndex) {
                    var rowText = this.getRowTextString(dataIndex);
                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        return true;
                    }

                    return false;
                };

                MemoryAnalyzerGridViewer.prototype._trySorting = function (sortOrder, sortColumns) {
                    var _this = this;
                    this._sortOrderIndex = sortOrder[0].index;
                    this._sortOrderOrder = sortOrder[0].order;
                    this.adaptor()._call(this._setFilterAndSortOrderHandler, this._filter, this._sortOrderIndex, this._sortOrderOrder).done(function () {
                        _this.getCanvas().scrollTop = 0;
                        _this.fireCustomEvent(_this.getCanvas(), "scroll");
                        _this.refresh();

                        _this._currentSelectedIndex = -1;
                        MemoryAnalyzerViewer.instance.resetCurrentSelectedIndex();

                        _this._refGraphShowCallback(false);
                        _this._clearSelection();
                        _this._refGraphNoDataElement.style.display = "block";
                    });
                    _super.prototype._trySorting.call(this, sortOrder, sortColumns);
                };

                MemoryAnalyzerGridViewer.prototype.translateColumn = function (row, index) {
                    var retval = _super.prototype.translateColumn.call(this, row, index);
                    if (!row) {
                        if (index === "TagName")
                            retval = Plugin.Resources.getString("LoadRowDataText");
                    } else {
                        if (index === "Count") {
                            if (row.Count === -1)
                                retval = "";
                            else {
                                if (!retval)
                                    retval = "0";
                                retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(retval, true, false);
                            }
                        } else if (index === "TotalSize" || index === "RetainedSize") {
                            if (row.Count === -1) {
                                retval = "";
                            } else {
                                if (!retval)
                                    retval = "0";
                                retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(retval, true, false);
                            }
                        } else if (index === "TagName") {
                            retval = MemoryAnalyzer.FormattingHelpers.getNativeDigitLocaleString(retval);
                        } else {
                            if (row.Count === 0 && row.TotalSize !== 0 || row.Count === -1)
                                retval = "";
                            else {
                                if (!retval)
                                    retval = "0";
                                if (parseInt(retval))
                                    retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(retval, true, true);
                            }
                        }
                    }
                    return retval;
                };

                MemoryAnalyzerGridViewer.prototype.translateExternalPathColumn = function (treePath, index) {
                    return index === "TagName" ? Plugin.Resources.getString("GridLastRow").replace("{0}", this.MaxRows.toString()) : "";
                };

                MemoryAnalyzerGridViewer.prototype.onSelectRow = function (rowIndex) {
                    if (this._currentSelectedIndex === this.getSelectedRowIndex())
                        return;
                    this.activateRow(rowIndex);
                };

                MemoryAnalyzerGridViewer.prototype.activateRow = function (rowIndex) {
                    this._currentSelectedIndex = this.getSelectedRowIndex();
                };

                MemoryAnalyzerGridViewer.prototype.reactivateCurrentRow = function () {
                    var selectedIndex = this.getSelectedRowIndex();
                    if (selectedIndex >= 0) {
                        this.activateRow(selectedIndex);
                    }
                };

                MemoryAnalyzerGridViewer.prototype.showRefGraph = function (show) {
                    this.showRefGraphNoData(!show);
                    this._refGraphShowCallback(show);
                };

                MemoryAnalyzerGridViewer.prototype.showRefGraphNoData = function (show) {
                    this._refGraphNoDataElement.style.display = show ? "block" : "none";
                };

                MemoryAnalyzerGridViewer.prototype.setDefaultSortOrder = function () {
                    this.onSort([new Common.Controls.Grid.SortOrderInfo(this._gridColumns[this._gridColumns.length - 1].index, "desc")], []);
                };
                return MemoryAnalyzerGridViewer;
            })(HeapViewer.MMADynamicGridViewer);

            var MemoryAnalyzerTypesGridViewer = (function (_super) {
                __extends(MemoryAnalyzerTypesGridViewer, _super);
                function MemoryAnalyzerTypesGridViewer(root, dataArray, gridContextMenu, columns, refGraphCallback, switchToObjectsView, snapshotType) {
                    var _this = this;
                    this._snapshotType = snapshotType;
                    var allowObjectsView = this.allowObjectsView();
                    gridContextMenu[1 /* Separator1 */].hidden = gridContextMenu[4 /* ViewInstances */].hidden = function () {
                        return !allowObjectsView;
                    };
                    if (allowObjectsView) {
                        gridContextMenu[4 /* ViewInstances */].disabled = function () {
                            var disableMenuItem;
                            _this.checkIfBaselineOnlyTypeAsync(_this.getRowInfo(_this.getSelectedRowIndex()), function (isBaselineOnlyType) {
                                disableMenuItem = isBaselineOnlyType;
                            });
                            return disableMenuItem;
                        };
                    }

                    gridContextMenu[4 /* ViewInstances */].callback = function () {
                        var row = _this.getRowInfo(_this.getSelectedRowIndex());
                        if (row)
                            _this.switchToObjects(row);
                    };

                    gridContextMenu[6 /* GoToDefinition */].callback = function () {
                        return _this.goToDefinition();
                    };
                    gridContextMenu[7 /* FindAllReferences */].callback = function () {
                        return _this.findAllReferences();
                    };

                    this._goToSourceState = 0 /* NotAvailable */;

                    gridContextMenu[5 /* Separator2 */].hidden = gridContextMenu[6 /* GoToDefinition */].hidden = gridContextMenu[7 /* FindAllReferences */].hidden = function () {
                        return _this._goToSourceState === 0 /* NotAvailable */;
                    };

                    gridContextMenu[5 /* Separator2 */].disabled = gridContextMenu[6 /* GoToDefinition */].disabled = gridContextMenu[7 /* FindAllReferences */].disabled = function () {
                        return _this._goToSourceState === 1 /* Disabled */;
                    };

                    _super.call(this, root, dataArray, gridContextMenu, columns, refGraphCallback, "TypeSummariesSetFilterAndSortOrder");

                    this.getGoToSourceStateAsync();

                    this._switchToObjectsViewCallback = switchToObjectsView;

                    if (this.allowObjectsView()) {
                        this.getCanvas().addEventListener("dblclick", function () {
                            _this.onDoubleClick.apply(_this, arguments);
                        });
                    }
                }
                MemoryAnalyzerTypesGridViewer.prototype.getGoToSourceStateAsync = function () {
                    var _this = this;
                    this.adaptor()._call("GetGoToSourceState").done(function (result) {
                        _this._goToSourceState = result;
                    });
                };

                MemoryAnalyzerTypesGridViewer.prototype.goToDefinition = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        _this.adaptor()._call("GoToDefinition", tag, 0 /* Type */);
                    });
                };

                MemoryAnalyzerTypesGridViewer.prototype.findAllReferences = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        _this.adaptor()._call("FindAllReferences", tag, 0 /* Type */);
                    });
                };

                MemoryAnalyzerTypesGridViewer.prototype.updateMouseOverRowStyle = function (row) {
                    this.pinObjectsViewIcon(row, "SnapshotGotoObjectsIconHover", false);
                };

                MemoryAnalyzerTypesGridViewer.prototype.updateMouseOutRowStyle = function (row) {
                    this.unpinObjectsViewIcon(row, "SnapshotGotoObjectsIconHover");
                };

                MemoryAnalyzerTypesGridViewer.prototype.updateSelectedRowStyle = function (row) {
                    this.pinObjectsViewIcon(row, "SnapshotGotoObjectsIconSelection", true);
                };

                MemoryAnalyzerTypesGridViewer.prototype.updateUnselectedRowStyle = function (row) {
                    this.unpinObjectsViewIcon(row, "SnapshotGotoObjectsIconSelection");
                };

                MemoryAnalyzerTypesGridViewer.prototype.pinObjectsViewIcon = function (row, cssClass, override) {
                    var _this = this;
                    if (!this.allowObjectsView())
                        return;

                    if (!row || row.row.children.length === 0)
                        throw Error("invalid row structure");

                    var column = (row.row.children[0]);
                    if (column.children.length === 0 || override) {
                        var icon = override && column.children[0] ? column.children[0] : document.createElement('span');

                        var tooltipText;
                        icon.className = cssClass;

                        this.checkIfBaselineOnlyTypeAsync(row, function (isBaselineOnlyType) {
                            if (isBaselineOnlyType) {
                                tooltipText = Plugin.Resources.getString("ObjectNotAvailable");
                                icon.classList.add("SnapshotGotoObjectsIconGrayOut");
                            } else {
                                tooltipText = Plugin.Resources.getString("ViewInstancesTooltip").replace("{0}", column.textContent);

                                icon.addEventListener("mousedown", function (e) {
                                    if (_this.isDirty())
                                        return;

                                    Plugin.Tooltip.dismiss();
                                    Plugin.ContextMenu.dismissAll();
                                    if (!e.button) {
                                        _this.switchToObjects(row);
                                    }
                                    e.stopPropagation();
                                });
                            }

                            icon.addEventListener("mouseover", function (e) {
                                Plugin.Tooltip.show(tooltipText);
                            });

                            column.appendChild(icon);
                        });
                    }
                };

                MemoryAnalyzerTypesGridViewer.prototype.unpinObjectsViewIcon = function (row, cssClass) {
                    if (!this.allowObjectsView())
                        return;

                    if (!row || row.row.children.length == 0)
                        throw Error("invalid row structure");

                    var column = (row.row.children[0]);

                    if (column.children[0] && column.children[0].classList.contains(cssClass)) {
                        column.removeChild(column.children[0]);
                    }
                };

                MemoryAnalyzerTypesGridViewer.prototype._onKeyDown = function (e) {
                    if (this.allowObjectsView() && e.keyCode === 13 /* ENTER */ && !this.isDirty()) {
                        var rowInfo = this.getRowInfo(this.getSelectedRowIndex());
                        if (rowInfo) {
                            Plugin.Tooltip.dismiss();
                            this.switchToObjects(rowInfo);
                            return true;
                        }
                    }

                    if (e.shiftKey && e.keyCode === 123 /* F12 */ && this._goToSourceState === 2 /* Enabled */ && this.getSelectedRowIndex() >= 0) {
                        this.findAllReferences();
                        return true;
                    }

                    if (e.keyCode == 123 /* F12 */ && this._goToSourceState === 2 /* Enabled */ && this.getSelectedRowIndex() >= 0) {
                        this.goToDefinition();
                        return true;
                    }

                    return _super.prototype._onKeyDown.call(this, e);
                };

                MemoryAnalyzerTypesGridViewer.prototype.switchToObjects = function (row) {
                    var _this = this;
                    this.checkIfBaselineOnlyTypeAsync(row, function (isBaselineOnlyType) {
                        if (!isBaselineOnlyType) {
                            var dataIndex = (row.dataIndex);
                            var typeName = row.row.children[0].innerText;
                            _this._dataArray.get(dataIndex.path, function (data) {
                                _this._switchToObjectsViewCallback(dataIndex, data, typeName);
                            });
                        }
                    });
                };

                MemoryAnalyzerTypesGridViewer.prototype.activateRow = function (rowIndex) {
                    var _this = this;
                    _super.prototype.activateRow.call(this, rowIndex);

                    if (rowIndex >= this.MaxRows - 1) {
                        this.showRefGraph(false);
                    } else {
                        var path = this.findPathByRow(rowIndex);
                        if (path.length() != 1)
                            throw Error("invalid path");

                        this._dataArray.get(path.path, function (value, needUpdate) {
                            _this.adaptor()._call("OnSelectType", value["Tag"]).done(function (isOk) {
                                if (isOk) {
                                    _this.showRefGraph(true);
                                }
                            });
                        });
                    }
                };

                MemoryAnalyzerTypesGridViewer.prototype.allowObjectsView = function () {
                    return this._snapshotType !== 1 /* GC_DUMP */;
                };

                MemoryAnalyzerTypesGridViewer.prototype.checkIfBaselineOnlyTypeAsync = function (rowInfo, callback) {
                    if (rowInfo && callback) {
                        var dataIndexTreePath = (rowInfo.dataIndex);

                        this._dataArray.get(dataIndexTreePath.path, function (data) {
                            if (data["Count"]) {
                                callback(false);
                            } else {
                                callback(true);
                            }
                        });
                    }
                };

                MemoryAnalyzerTypesGridViewer.prototype.onDoubleClick = function (e) {
                    var rowInfo = this.getRowInfoFromEvent(e, "." + this.options().rowClass);
                    if (rowInfo) {
                        this.switchToObjects(rowInfo);
                    }
                };
                return MemoryAnalyzerTypesGridViewer;
            })(MemoryAnalyzerGridViewer);

            var MemoryAnalyzerObjectsGridViewer = (function (_super) {
                __extends(MemoryAnalyzerObjectsGridViewer, _super);
                function MemoryAnalyzerObjectsGridViewer(root, dataArray, gridContextMenu, columns, refGraphCallback, maxObjectsCount) {
                    var _this = this;
                    gridContextMenu[1 /* Separator1 */].hidden = gridContextMenu[2 /* AddWatch */].hidden = gridContextMenu[3 /* QuickWatch */].hidden = function () {
                        return false;
                    };

                    gridContextMenu[5 /* Separator2 */].hidden = gridContextMenu[6 /* GoToDefinition */].hidden = function () {
                        return true;
                    };
                    gridContextMenu[7 /* FindAllReferences */].hidden = function () {
                        return true;
                    };

                    gridContextMenu[2 /* AddWatch */].callback = function () {
                        return _this.addWatch();
                    };
                    gridContextMenu[3 /* QuickWatch */].callback = function () {
                        return _this.quickWatch();
                    };

                    _super.call(this, root, dataArray, gridContextMenu, columns, refGraphCallback, "ObjectSummariesSetFilterAndSortOrder");

                    this._dataArray = dataArray;
                    if (maxObjectsCount !== 0) {
                        this.MaxRows = maxObjectsCount;
                    }
                    this._dataArray.registerAsyncResultCallback(function (index, value) {
                        return _this.updateValueColumnAsync(index, value);
                    });
                    this.adaptor().addEventListener("objectsFilteringProgress", function (reply) {
                        return _this.onObjectsFilteringProgress(reply.Progress, reply.DataUpdated);
                    });
                }
                MemoryAnalyzerObjectsGridViewer.prototype.setCurrentTypeAsync = function (type) {
                    var _this = this;
                    this._dataArray.flushCache();
                    this.adaptor()._call("ObjectsInspectionSetType", type).done(function (count) {
                        _this._dataArray.init(function () {
                            _this.activateWithDynamicData(count);
                            _this.setDefaultSortOrder();
                            _this.scheduleUpdate();
                        });
                    });
                };

                MemoryAnalyzerObjectsGridViewer.prototype.activateRow = function (rowIndex) {
                    var _this = this;
                    _super.prototype.activateRow.call(this, rowIndex);

                    var path = this.findPathByRow(rowIndex);
                    if (path.length() != 1)
                        throw Error("invalid path");

                    if (rowIndex >= this.MaxRows - 1) {
                        this.showRefGraph(false);
                    } else {
                        this._dataArray.get(path.path, function (value, needUpdate) {
                            var objectTag = value["Tag"];
                            _this.adaptor()._call("OnSelectObject", objectTag).done(function (isOk) {
                                if (isOk) {
                                    _this.showRefGraph(true);
                                }
                            });
                        });
                    }
                };

                MemoryAnalyzerObjectsGridViewer.prototype.translateExternalPathColumn = function (treePath, index) {
                    return index === "TagName" ? Plugin.Resources.getString("GridTrimLimit").replace("{0}", this.MaxRows.toString()) : "";
                };

                MemoryAnalyzerObjectsGridViewer.prototype.updateValueColumnAsync = function (path, value) {
                    path = value.path;
                    if (!path) {
                        return;
                    }
                    var rowInfo = this.getRowInfo(path.at(0));
                    if (!rowInfo) {
                        return;
                    }

                    var valueColumn = rowInfo.row.children[1];
                    valueColumn.innerText = value["Value"];
                };

                MemoryAnalyzerObjectsGridViewer.prototype.setFilterAsync = function (filterString) {
                    var _this = this;
                    this.setSearchProgressBarState(false, 0);
                    this.adaptor()._call("CancelObjectsFiltering").done(function () {
                        _this._dataArray.flushCache();
                        _super.prototype.setFilterAsync.call(_this, filterString);
                        if (filterString && filterString.length > 0) {
                            _this.setSearchProgressBarState(true, 0);
                        }
                    });
                };

                MemoryAnalyzerObjectsGridViewer.prototype.onObjectsFilteringProgress = function (progress, dataUpdated) {
                    if (dataUpdated) {
                        this._dataArray.flushCache();
                        this.refresh();
                        this.showRefGraph(false);
                    }
                    this.setSearchProgressBarState(progress < 100, progress);
                };

                MemoryAnalyzerObjectsGridViewer.prototype.setSearchProgressBarState = function (show, progress) {
                    var filteringProgressBar = document.querySelector("#filterInputProgressBar");
                    filteringProgressBar.style.visibility = show ? "visible" : "hidden";
                    filteringProgressBar.value = progress;
                };

                MemoryAnalyzerObjectsGridViewer.prototype._trySorting = function (sortOrder, sortColumns) {
                    var _this = this;
                    this.adaptor()._call("CancelAsyncObjectsEvaluation").done(function () {
                        _this._dataArray.flushCache();
                        _super.prototype._trySorting.call(_this, sortOrder, sortColumns);
                    });
                };

                MemoryAnalyzerObjectsGridViewer.prototype.getDatatipCell = function (e, element) {
                    var rowElement = element.parentNode;
                    if (!rowElement || rowElement.children.length < 1)
                        throw Error("incorrect grid control row");
                    var valueColumnElement = rowElement.children[1];
                    if (valueColumnElement !== element)
                        return null;
                    return valueColumnElement;
                };

                MemoryAnalyzerObjectsGridViewer.prototype._onKeyDown = function (e) {
                    if (e.keyCode === 13 /* ENTER */ && !this.isDirty()) {
                        this.quickWatch();
                        return true;
                    }
                    return _super.prototype._onKeyDown.call(this, e);
                };
                return MemoryAnalyzerObjectsGridViewer;
            })(MemoryAnalyzerGridViewer);

            var MemoryAnalyzerTypeRefGraphViewer = (function (_super) {
                __extends(MemoryAnalyzerTypeRefGraphViewer, _super);
                function MemoryAnalyzerTypeRefGraphViewer(root, dataArray, gridContextMenu, columns, direction) {
                    var _this = this;
                    this._gridColumns = columns;
                    var options = new Common.Controls.DynamicGrid.DynamicGridViewerOptions(gridContextMenu, null, this._gridColumns, null);
                    options.overflowColumn = true;
                    options.header = true;
                    options.focusable = true;

                    gridContextMenu[6 /* GoToDefinition */].callback = function () {
                        return _this.goToDefinition();
                    };
                    gridContextMenu[7 /* FindAllReferences */].callback = function () {
                        return _this.findAllReferences();
                    };

                    this._goToSourceState = 0 /* NotAvailable */;

                    gridContextMenu[5 /* Separator2 */].hidden = gridContextMenu[6 /* GoToDefinition */].hidden = gridContextMenu[7 /* FindAllReferences */].hidden = function () {
                        return _this._goToSourceState === 0 /* NotAvailable */;
                    };

                    gridContextMenu[5 /* Separator2 */].disabled = gridContextMenu[6 /* GoToDefinition */].disabled = gridContextMenu[7 /* FindAllReferences */].disabled = function () {
                        return _this._goToSourceState === 1 /* Disabled */;
                    };

                    _super.call(this, dataArray, root, options);

                    this.getGoToSourceStateAsync();

                    this._graphDomElement = root;
                    this._graphDirection = direction;
                    this.showGraph(false);

                    this.onSort([new Common.Controls.Grid.SortOrderInfo(this._gridColumns[this._gridColumns.length - 1].index, "desc")], []);
                }
                MemoryAnalyzerTypeRefGraphViewer.prototype.getGoToSourceStateAsync = function () {
                    var _this = this;
                    this.adaptor()._call("GetGoToSourceState").done(function (result) {
                        _this._goToSourceState = result;
                    });
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.goToDefinition = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        var category = value["Category"];
                        _this.adaptor()._call("GoToDefinition", tag, category);
                    });
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.findAllReferences = function () {
                    var _this = this;
                    var dataIndex = this.getSelectedDataIndex();

                    this._dataArray.get(dataIndex.path, function (value) {
                        var tag = value["Tag"];
                        var category = value["Category"];
                        _this.adaptor()._call("FindAllReferences", tag, category);
                    });
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype._onKeyDown = function (e) {
                    if (e.shiftKey && e.keyCode === 123 /* F12 */ && this._goToSourceState === 2 /* Enabled */ && this.getSelectedRowIndex() >= 0) {
                        this.findAllReferences();
                        return true;
                    }

                    if (e.keyCode == 123 /* F12 */ && this._goToSourceState === 2 /* Enabled */ && this.getSelectedRowIndex() >= 0) {
                        this.goToDefinition();
                        return true;
                    }

                    return _super.prototype._onKeyDown.call(this, e);
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.translateColumn = function (row, index) {
                    var retval;
                    if (!row) {
                        if (index === "TagName")
                            retval = Plugin.Resources.getString("LoadRowDataText");
                    } else {
                        retval = row && row[index] !== undefined ? row[index] : "";

                        if ((index === "RetainedCount" || index === "RefCount" || index === "RetainedSize" || index === "Count" || index === "TotalSize") && retval !== "") {
                            retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(retval, true, false);
                        }
                        if (index.search("Diff") !== -1) {
                            if (row["RetainedCount"] !== undefined || row["RefCount"] !== undefined) {
                                retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(retval, true, true);
                            } else
                                retval = "";
                        }
                    }
                    return retval;
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.translateExternalPathColumn = function (treePath, index) {
                    return index === "TagName" ? Plugin.Resources.getString("GridLastRow").replace("{0}", (this.getFirstLevelCount() - treePath.path[0]).toString()) : "";
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.showGraph = function (show) {
                    this._graphDomElement.style.display = show ? "block" : "none";
                    if (show) {
                        this.initializeDataSource();
                        this.scheduleUpdate();
                    }
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.expandRoot = function () {
                    this.expandNode(new Common.Controls.DynamicGrid.TreePath([0]));
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.onCtrlC = function () {
                    var dataIndex = this.getSelectedDataIndex();
                    var rowText = this.getRowTextString(dataIndex);

                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        MemoryAnalyzerViewer.copySelectedRowToClipboard(null, null, null);
                    }
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.initializeContextMenu = function (dataIndex) {
                    var rowText = this.getRowTextString(dataIndex);
                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        return true;
                    }

                    return false;
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype._trySorting = function (sortOrder, sortColumns) {
                    var _this = this;
                    this._sortOrderIndex = sortOrder[0].index;
                    this._sortOrderOrder = sortOrder[0].order;
                    this.refreshSortingOrder(function () {
                        _this.refresh();
                        _this.expandRoot();
                    });
                    _super.prototype._trySorting.call(this, sortOrder, sortColumns);
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.refreshSortingOrder = function (next) {
                    if (typeof next === "undefined") { next = function () {
                    }; }
                    this.adaptor()._call("TypeRefGraphSetSortOrder", this._sortOrderIndex, this._sortOrderOrder).done(function () {
                        next();
                    });
                };

                MemoryAnalyzerTypeRefGraphViewer.prototype.onSelectRow = function (rowIndex) {
                    this.adaptor()._call("OnSelectTypeRefGraph", this._graphDirection);
                };
                return MemoryAnalyzerTypeRefGraphViewer;
            })(HeapViewer.MMADynamicGridViewer);

            var MemoryAnalyzerRefGraphViewer = (function (_super) {
                __extends(MemoryAnalyzerRefGraphViewer, _super);
                function MemoryAnalyzerRefGraphViewer(root, dataArray, gridContextMenu, columns, direction) {
                    var _this = this;
                    this._gridColumns = columns;
                    this._graphDirection = direction;

                    if (this._graphDirection === 1 /* Backward */) {
                        this._gridColumns[0].getCellContents = function (rowInfo, dataIndex, expandedState, level, column, indentIndex, columnOrder) {
                            return _this._drawRefCell(rowInfo, dataIndex, expandedState, level, column, indentIndex, columnOrder);
                        };
                    }

                    var options = new Common.Controls.DynamicGrid.DynamicGridViewerOptions(gridContextMenu, null, this._gridColumns, null);
                    options.overflowColumn = true;
                    options.focusable = true;

                    gridContextMenu[1 /* Separator1 */].hidden = gridContextMenu[2 /* AddWatch */].hidden = gridContextMenu[3 /* QuickWatch */].hidden = function () {
                        return false;
                    };

                    gridContextMenu[5 /* Separator2 */].hidden = gridContextMenu[6 /* GoToDefinition */].hidden = function () {
                        return true;
                    };
                    gridContextMenu[7 /* FindAllReferences */].hidden = function () {
                        return true;
                    };

                    gridContextMenu[2 /* AddWatch */].callback = function () {
                        return _this.addWatch();
                    };
                    gridContextMenu[3 /* QuickWatch */].callback = function () {
                        return _this.quickWatch();
                    };

                    _super.call(this, dataArray, root, options);

                    this._graphDomElement = root;
                    this.showGraph(false);
                }
                MemoryAnalyzerRefGraphViewer.prototype.translateColumn = function (row, index) {
                    var retval;
                    if (!row) {
                        if (index === "TagName")
                            retval = Plugin.Resources.getString("LoadRowDataText");
                    } else if (this._graphDirection === 0 /* Forward */) {
                        if (index === "TagName") {
                            retval = MemoryAnalyzer.FormattingHelpers.getNativeDigitLocaleString(row["TypeName"] + "    " + row["TagName"]);
                        } else {
                            retval = MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(_super.prototype.translateColumn.call(this, row, index), true, false);
                        }
                    } else {
                        retval = MemoryAnalyzer.FormattingHelpers.getNativeDigitLocaleString(row["TypeName"] + "    " + row["TagName"]);
                    }
                    return retval;
                };

                MemoryAnalyzerRefGraphViewer.prototype.translateExternalPathColumn = function (treePath, index) {
                    return index === "TagName" ? Plugin.Resources.getString("GridLastRow").replace("{0}", (this.getFirstLevelCount() - treePath.path[0]).toString()) : "";
                };

                MemoryAnalyzerRefGraphViewer.prototype.showGraph = function (show) {
                    this._graphDomElement.style.display = show ? "block" : "none";
                    this.tryToCloseDataTip(true);
                    if (show) {
                        this.initializeDataSource();
                        this.scheduleUpdate();
                    }
                };

                MemoryAnalyzerRefGraphViewer.prototype.expandRoot = function () {
                    var treePath = new Common.Controls.DynamicGrid.TreePath([0]);

                    if (this._graphDirection === 0 /* Forward */) {
                        this.expandNode(treePath);
                    } else {
                        this.expandPathToRoot(treePath, this._dataArray.dataSourceGeneration());
                    }
                };

                MemoryAnalyzerRefGraphViewer.prototype.expandPathToRoot = function (treePath, dataSourceGeneration, callback) {
                    var _this = this;
                    this.getValue(treePath, function (value, needUpdate) {
                        if (dataSourceGeneration !== _this._dataArray.dataSourceGeneration()) {
                            return;
                        }
                        if (value.IsOnPathToRoot === true) {
                            _this.expandNode(treePath);
                            var subItemsCount = value["SubItemsCount"];
                            _this.expandPathToRootHelper(treePath, 0, subItemsCount, dataSourceGeneration, callback);
                        } else if (callback) {
                            callback();
                        }
                    });
                };

                MemoryAnalyzerRefGraphViewer.prototype.expandPathToRootHelper = function (treePath, i, subItemsCount, dataSourceGeneration, callback) {
                    var _this = this;
                    if (dataSourceGeneration !== this._dataArray.dataSourceGeneration()) {
                        return;
                    }
                    if (i < subItemsCount) {
                        var childTreePath = new Common.Controls.DynamicGrid.TreePath(treePath.path);
                        childTreePath.concat(new Common.Controls.DynamicGrid.TreePath([i]));
                        this.expandPathToRoot(childTreePath, dataSourceGeneration, function () {
                            if (dataSourceGeneration !== _this._dataArray.dataSourceGeneration()) {
                                return;
                            }
                            _this.expandPathToRootHelper(treePath, i + 1, dataSourceGeneration, subItemsCount);
                        });
                    } else if (callback)
                        callback();
                };

                MemoryAnalyzerRefGraphViewer.prototype._drawRefCell = function (rowInfo, dataIndex, expandedState, level, column, indentIndex, columnOrder) {
                    var _this = this;
                    column.width = this.canvasClientWidth() - 4;

                    var cellElement = this.createElementWithClass("div", "grid-cell-ref");
                    cellElement.style.width = (column.width) + "px";

                    var value = this.getColumnText(dataIndex, column, columnOrder);

                    Common.Controls.Grid.GridControl._setTooltip(cellElement, column.hasHTMLContent ? "" : value, 65);

                    if (value) {
                        cellElement.innerText = value;
                    } else {
                        cellElement.innerHTML = "&nbsp;";
                    }

                    if (columnOrder === indentIndex && level > 0) {
                        var indent = ((level * 16) - 13);
                        column.indentOffset = indent;
                        if (expandedState !== 0) {
                            var treeSign = this.createElementWithClass("div", "icon grid-tree-icon");
                            treeSign.style.left = indent + "px";
                            cellElement.appendChild(treeSign);
                            if (expandedState > 0) {
                                treeSign.classList.add("icon-tree-expanded");
                            } else {
                                treeSign.classList.add("icon-tree-collapsed");
                            }

                            treeSign.addEventListener("mouseover", function (e) {
                                _this.onTreeIconMouseOver(e);
                            });
                            treeSign.addEventListener("mouseout", function (e) {
                                _this.onTreeIconMouseOut(e);
                            });
                        }

                        cellElement.style.textIndent = (level * 16) + "px";
                    }

                    return cellElement;
                };

                MemoryAnalyzerRefGraphViewer.prototype.onCtrlC = function () {
                    var dataIndex = this.getSelectedDataIndex();
                    var rowText = this.getRowTextString(dataIndex);

                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        MemoryAnalyzerViewer.copySelectedRowToClipboard(null, null, null);
                    }
                };

                MemoryAnalyzerRefGraphViewer.prototype.initializeContextMenu = function (dataIndex) {
                    var rowText = this.getRowTextString(dataIndex);
                    if (rowText) {
                        MemoryAnalyzerViewer.dataForClipboard = rowText;
                        return true;
                    }

                    return false;
                };

                MemoryAnalyzerRefGraphViewer.prototype._onContainerResize = function (e) {
                    if (this._graphDirection === 1 /* Backward */) {
                        this._gridColumns[0].width = this.canvasClientWidth() - 4;
                    }
                    _super.prototype._onContainerResize.call(this, e);
                };

                MemoryAnalyzerRefGraphViewer.prototype._updateViewport = function (includeNonDirtyRows) {
                    _super.prototype._updateViewport.call(this, includeNonDirtyRows);

                    if (this._graphDirection === 1 /* Backward */) {
                        this.widenRows(this.canvasClientWidth());
                    }
                };

                MemoryAnalyzerRefGraphViewer.prototype._trySorting = function (sortOrder, sortColumns) {
                    var _this = this;
                    this._sortOrderIndex = sortOrder[0].index;
                    this._sortOrderOrder = sortOrder[0].order;
                    this.refreshSortingOrder(function () {
                        _this.refresh();
                        _this.expandRoot();
                    });
                    _super.prototype._trySorting.call(this, sortOrder, sortColumns);
                };

                MemoryAnalyzerRefGraphViewer.prototype.refreshSortingOrder = function (next) {
                    if (typeof next === "undefined") { next = function () {
                    }; }
                    this.adaptor()._call("ForwardRefGraphSetSortOrder", this._sortOrderIndex, this._sortOrderOrder).done(function () {
                        next();
                    });
                };

                MemoryAnalyzerRefGraphViewer.prototype.getDatatipCell = function (e, element) {
                    var rowElement = element.parentNode;
                    if (!rowElement || rowElement.children.length < 1)
                        throw Error("incorrect grid control row");
                    var valueColumnElement = rowElement.children[0];
                    if (valueColumnElement !== element)
                        return null;
                    return valueColumnElement;
                };

                MemoryAnalyzerRefGraphViewer.prototype.onSelectRow = function (rowIndex) {
                    this.adaptor()._call("OnSelectObjectRefGraph", this._graphDirection);
                };
                return MemoryAnalyzerRefGraphViewer;
            })(HeapViewer.MMADynamicGridViewer);

            function isHighContrastThemeCompatibilityProblem() {
                if (!document.body.classList.contains("IE9"))
                    return false;

                var TestColor = 'rgb(31, 41, 59)';
                var testDiv = document.createElement('div');
                testDiv.style.color = TestColor;
                document.body.appendChild(testDiv);

                var color = testDiv.currentStyle.color;

                document.body.removeChild(testDiv);
                return color !== TestColor;
            }

            function showHighContrastUnsupportedMessage() {
                var splash = document.createElement("div");
                splash.className = "SplashScreen";
                var message = document.createElement("div");
                message.innerHTML = "<a href='http://go.microsoft.com/fwlink/p/?LinkId=331160' target='_blank'>" + Plugin.Resources.getString("HighContrastUnsupportedBrowserMessage") + "</a>";
                splash.appendChild(message);
                document.body.appendChild(splash);
            }

            Plugin.addEventListener("pluginready", function () {
                if (isHighContrastThemeCompatibilityProblem()) {
                    showHighContrastUnsupportedMessage();
                } else {
                    MemoryAnalyzerViewer.instance = new MemoryAnalyzerViewer();
                }
            });
        })(ManagedMemoryAnalyzer.HeapViewer || (ManagedMemoryAnalyzer.HeapViewer = {}));
        var HeapViewer = ManagedMemoryAnalyzer.HeapViewer;
    })(Debugger.ManagedMemoryAnalyzer || (Debugger.ManagedMemoryAnalyzer = {}));
    var ManagedMemoryAnalyzer = Debugger.ManagedMemoryAnalyzer;
})(Debugger || (Debugger = {}));

// SIG // Begin signature block
// SIG // MIIarQYJKoZIhvcNAQcCoIIanjCCGpoCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFP81MJIQ3CyZ
// SIG // tPCvxUIKFETBl4FIoIIVejCCBLswggOjoAMCAQICEzMA
// SIG // AABa7S/05CCZPzoAAAAAAFowDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE0MDUyMzE3
// SIG // MTMxNVoXDTE1MDgyMzE3MTMxNVowgasxCzAJBgNVBAYT
// SIG // AlVTMQswCQYDVQQIEwJXQTEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IERTRSBFU046QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMT
// SIG // HE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2UwggEi
// SIG // MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCzISLf
// SIG // atC/+ynJ1Wx6iamNE7yUtel9KWXaf/Qfqwx5YWZUYZYH
// SIG // 8NRgSzGbCa99KG3QpXuHX3ah0sYpx5Y6o18XjHbgt5YH
// SIG // D8diYbS2qvZGFCkDLiawHUoI4H3TXDASppv2uQ49UxZp
// SIG // nbtlJ0LB6DI1Dvcp/95bIEy7L2iEJA+rkcTzzipeWEbt
// SIG // qUW0abZUJpESYv1vDuTP+dw/2ilpH0qu7sCCQuuCc+lR
// SIG // UxG/3asdb7IKUHgLg+8bCLMbZ2/TBX2hCZ/Cd4igo1jB
// SIG // T/9n897sx/Uz3IpFDpZGFCiHHGC39apaQExwtWnARsjU
// SIG // 6OLFkN4LZTXUVIDS6Z0gVq/U3825AgMBAAGjggEJMIIB
// SIG // BTAdBgNVHQ4EFgQUvmfgLgIbrwpyDTodf4ydayJmEfcw
// SIG // HwYDVR0jBBgwFoAUIzT42VJGcArtQPt2+7MrsMM1sw8w
// SIG // VAYDVR0fBE0wSzBJoEegRYZDaHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWljcm9z
// SIG // b2Z0VGltZVN0YW1wUENBLmNybDBYBggrBgEFBQcBAQRM
// SIG // MEowSAYIKwYBBQUHMAKGPGh0dHA6Ly93d3cubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY2VydHMvTWljcm9zb2Z0VGltZVN0
// SIG // YW1wUENBLmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAQEAIFOCkK6mTU5+M0nIs63E
// SIG // w34V0BLyDyeKf1u/PlTqQelUAysput1UiLu599nOU+0Q
// SIG // Fj3JRnC0ANHyNF2noyIsqiLha6G/Dw2H0B4CG+94tokg
// SIG // 0CyrC3Q4LqYQ/9qRqyxAPCYVqqzews9KkwPNa+Kkspka
// SIG // XUdE8dyCH+ZItKZpmcEu6Ycj6gjSaeZi33Hx6yO/IWX5
// SIG // pFfEky3bFngVqj6i5IX8F77ATxXbqvCouhErrPorNRZu
// SIG // W3P+MND7q5Og3s1C2jY/kffgN4zZB607J7v/VCB3xv0R
// SIG // 6RrmabIzJ6sFrliPpql/XRIRaAwsozEWDb4hq5zwrhp8
// SIG // QNXWgxYV2Cj75TCCBOwwggPUoAMCAQICEzMAAADKbNUy
// SIG // EjXE4VUAAQAAAMowDQYJKoZIhvcNAQEFBQAweTELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0
// SIG // IENvZGUgU2lnbmluZyBQQ0EwHhcNMTQwNDIyMTczOTAw
// SIG // WhcNMTUwNzIyMTczOTAwWjCBgzELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjENMAsGA1UECxMETU9QUjEeMBwGA1UEAxMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEAlnFd7QZG+oTLnVu3Rsew
// SIG // 4bQROQOtsRVzYJzrp7ZuGjw//2XjNPGmpSFeVplsWOSS
// SIG // oQpcwtPcUi8MZZogYUBTMZxsjyF9uvn+E1BSYJU6W7lY
// SIG // pXRhQamU4K0mTkyhl3BJJ158Z8pPHnGERrwdS7biD8XG
// SIG // J8kH5noKpRcAGUxwRTgtgbRQqsVn0fp5vMXMoXKb9CU0
// SIG // mPhU3xI5OBIvpGulmn7HYtHcz+09NPi53zUwuux5Mqnh
// SIG // qaxVTUx/TFbDEwt28Qf5zEes+4jVUqUeKPo9Lc/PhJiG
// SIG // cWURz4XJCUSG4W/nsfysQESlqYsjP4JJndWWWVATWRhz
// SIG // /0MMrSvUfzBAZwIDAQABo4IBYDCCAVwwEwYDVR0lBAww
// SIG // CgYIKwYBBQUHAwMwHQYDVR0OBBYEFB9e4l1QjVaGvko8
// SIG // zwTop4e1y7+DMFEGA1UdEQRKMEikRjBEMQ0wCwYDVQQL
// SIG // EwRNT1BSMTMwMQYDVQQFEyozMTU5NStiNDIxOGYxMy02
// SIG // ZmNhLTQ5MGYtOWM0Ny0zZmM1NTdkZmM0NDAwHwYDVR0j
// SIG // BBgwFoAUyxHoytK0FlgByTcuMxYWuUyaCh8wVgYDVR0f
// SIG // BE8wTTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jcmwvcHJvZHVjdHMvTWljQ29kU2lnUENB
// SIG // XzA4LTMxLTIwMTAuY3JsMFoGCCsGAQUFBwEBBE4wTDBK
// SIG // BggrBgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNDb2RTaWdQQ0FfMDgtMzEt
// SIG // MjAxMC5jcnQwDQYJKoZIhvcNAQEFBQADggEBAHdc69eR
// SIG // Pc29e4PZhamwQ51zfBfJD+0228e1LBte+1QFOoNxQIEJ
// SIG // ordxJl7WfbZsO8mqX10DGCodJ34H6cVlH7XPDbdUxyg4
// SIG // Wojne8EZtlYyuuLMy5Pbr24PXUT11LDvG9VOwa8O7yCb
// SIG // 8uH+J13oxf9h9hnSKAoind/NcIKeGHLYI8x6LEPu/+rA
// SIG // 4OYdqp6XMwBSbwe404hs3qQGNafCU4ZlEXcJjzVZudiG
// SIG // qAD++DF9LPSMBZ3AwdV3cmzpTVkmg/HCsohXkzUAfFAr
// SIG // vFn8/hwpOILT3lKXRSkYTpZbnbpfG6PxJ1DqB5XobTQN
// SIG // OFfcNyg1lTo4nNTtaoVdDiIRXnswggW8MIIDpKADAgEC
// SIG // AgphMyYaAAAAAAAxMA0GCSqGSIb3DQEBBQUAMF8xEzAR
// SIG // BgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZ
// SIG // FgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0xMDA4
// SIG // MzEyMjE5MzJaFw0yMDA4MzEyMjI5MzJaMHkxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xIzAhBgNVBAMTGk1pY3Jvc29mdCBD
// SIG // b2RlIFNpZ25pbmcgUENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAsnJZXBkwZL8dmmAgIEKZdlNs
// SIG // PhvWb8zL8epr/pcWEODfOnSDGrcvoDLs/97CQk4j1XIA
// SIG // 2zVXConKriBJ9PBorE1LjaW9eUtxm0cH2v0l3511iM+q
// SIG // c0R/14Hb873yNqTJXEXcr6094CholxqnpXJzVvEXlOT9
// SIG // NZRyoNZ2Xx53RYOFOBbQc1sFumdSjaWyaS/aGQv+knQp
// SIG // 4nYvVN0UMFn40o1i/cvJX0YxULknE+RAMM9yKRAoIsc3
// SIG // Tj2gMj2QzaE4BoVcTlaCKCoFMrdL109j59ItYvFFPees
// SIG // CAD2RqGe0VuMJlPoeqpK8kbPNzw4nrR3XKUXno3LEY9W
// SIG // PMGsCV8D0wIDAQABo4IBXjCCAVowDwYDVR0TAQH/BAUw
// SIG // AwEB/zAdBgNVHQ4EFgQUyxHoytK0FlgByTcuMxYWuUya
// SIG // Ch8wCwYDVR0PBAQDAgGGMBIGCSsGAQQBgjcVAQQFAgMB
// SIG // AAEwIwYJKwYBBAGCNxUCBBYEFP3RMU7TJoqV4ZhgO6gx
// SIG // b6Y8vNgtMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIAQwBB
// SIG // MB8GA1UdIwQYMBaAFA6sgmBAVieX5SUT/CrhClOVWeSk
// SIG // MFAGA1UdHwRJMEcwRaBDoEGGP2h0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL21pY3Jv
// SIG // c29mdHJvb3RjZXJ0LmNybDBUBggrBgEFBQcBAQRIMEYw
// SIG // RAYIKwYBBQUHMAKGOGh0dHA6Ly93d3cubWljcm9zb2Z0
// SIG // LmNvbS9wa2kvY2VydHMvTWljcm9zb2Z0Um9vdENlcnQu
// SIG // Y3J0MA0GCSqGSIb3DQEBBQUAA4ICAQBZOT5/Jkav629A
// SIG // sTK1ausOL26oSffrX3XtTDst10OtC/7L6S0xoyPMfFCY
// SIG // gCFdrD0vTLqiqFac43C7uLT4ebVJcvc+6kF/yuEMF2nL
// SIG // pZwgLfoLUMRWzS3jStK8cOeoDaIDpVbguIpLV/KVQpzx
// SIG // 8+/u44YfNDy4VprwUyOFKqSCHJPilAcd8uJO+IyhyugT
// SIG // pZFOyBvSj3KVKnFtmxr4HPBT1mfMIv9cHc2ijL0nsnlj
// SIG // VkSiUc356aNYVt2bAkVEL1/02q7UgjJu/KSVE+Traeep
// SIG // oiy+yCsQDmWOmdv1ovoSJgllOJTxeh9Ku9HhVujQeJYY
// SIG // XMk1Fl/dkx1Jji2+rTREHO4QFRoAXd01WyHOmMcJ7oUO
// SIG // jE9tDhNOPXwpSJxy0fNsysHscKNXkld9lI2gG0gDWvfP
// SIG // o2cKdKU27S0vF8jmcjcS9G+xPGeC+VKyjTMWZR4Oit0Q
// SIG // 3mT0b85G1NMX6XnEBLTT+yzfH4qerAr7EydAreT54al/
// SIG // RrsHYEdlYEBOsELsTu2zdnnYCjQJbRyAMR/iDlTd5aH7
// SIG // 5UcQrWSY/1AWLny/BSF64pVBJ2nDk4+VyY3YmyGuDVyc
// SIG // 8KKuhmiDDGotu3ZrAB2WrfIWe/YWgyS5iM9qqEcxL5rc
// SIG // 43E91wB+YkfRzojJuBj6DnKNwaM9rwJAav9pm5biEKgQ
// SIG // tDdQCNbDPTCCBgcwggPvoAMCAQICCmEWaDQAAAAAABww
// SIG // DQYJKoZIhvcNAQEFBQAwXzETMBEGCgmSJomT8ixkARkW
// SIG // A2NvbTEZMBcGCgmSJomT8ixkARkWCW1pY3Jvc29mdDEt
// SIG // MCsGA1UEAxMkTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
// SIG // dGUgQXV0aG9yaXR5MB4XDTA3MDQwMzEyNTMwOVoXDTIx
// SIG // MDQwMzEzMDMwOVowdzELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEh
// SIG // MB8GA1UEAxMYTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
// SIG // MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
// SIG // n6Fssd/bSJIqfGsuGeG94uPFmVEjUK3O3RhOJA/u0afR
// SIG // TK10MCAR6wfVVJUVSZQbQpKumFwwJtoAa+h7veyJBw/3
// SIG // DgSY8InMH8szJIed8vRnHCz8e+eIHernTqOhwSNTyo36
// SIG // Rc8J0F6v0LBCBKL5pmyTZ9co3EZTsIbQ5ShGLieshk9V
// SIG // UgzkAyz7apCQMG6H81kwnfp+1pez6CGXfvjSE/MIt1Nt
// SIG // UrRFkJ9IAEpHZhEnKWaol+TTBoFKovmEpxFHFAmCn4Tt
// SIG // VXj+AZodUAiFABAwRu233iNGu8QtVJ+vHnhBMXfMm987
// SIG // g5OhYQK1HQ2x/PebsgHOIktU//kFw8IgCwIDAQABo4IB
// SIG // qzCCAacwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU
// SIG // IzT42VJGcArtQPt2+7MrsMM1sw8wCwYDVR0PBAQDAgGG
// SIG // MBAGCSsGAQQBgjcVAQQDAgEAMIGYBgNVHSMEgZAwgY2A
// SIG // FA6sgmBAVieX5SUT/CrhClOVWeSkoWOkYTBfMRMwEQYK
// SIG // CZImiZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJ
// SIG // bWljcm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9v
// SIG // dCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHmCEHmtFqFKoKWt
// SIG // THNY9AcTLmUwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
// SIG // DQYJKoZIhvcNAQEFBQADggIBABCXisNcA0Q23em0rXfb
// SIG // znlRTQGxLnRxW20ME6vOvnuPuC7UEqKMbWK4VwLLTiAT
// SIG // UJndekDiV7uvWJoc4R0Bhqy7ePKL0Ow7Ae7ivo8KBciN
// SIG // SOLwUxXdT6uS5OeNatWAweaU8gYvhQPpkSokInD79vzk
// SIG // eJkuDfcH4nC8GE6djmsKcpW4oTmcZy3FUQ7qYlw/FpiL
// SIG // ID/iBxoy+cwxSnYxPStyC8jqcD3/hQoT38IKYY7w17gX
// SIG // 606Lf8U1K16jv+u8fQtCe9RTciHuMMq7eGVcWwEXChQO
// SIG // 0toUmPU8uWZYsy0v5/mFhsxRVuidcJRsrDlM1PZ5v6oY
// SIG // emIp76KbKTQGdxpiyT0ebR+C8AvHLLvPQ7Pl+ex9teOk
// SIG // qHQ1uE7FcSMSJnYLPFKMcVpGQxS8s7OwTWfIn0L/gHkh
// SIG // gJ4VMGboQhJeGsieIiHQQ+kr6bv0SMws1NgygEwmKkgk
// SIG // X1rqVu+m3pmdyjpvvYEndAYR7nYhv5uCwSdUtrFqPYmh
// SIG // dmG0bqETpr+qR/ASb/2KMmyy/t9RyIwjyWa9nR2HEmQC
// SIG // PS2vWY+45CHltbDKY7R4VAXUQS5QrJSwpXirs6CWdRrZ
// SIG // kocTdSIvMqgIbqBbjCW/oO+EyiHW6x5PyZruSeD3AWVv
// SIG // iQt9yGnI5m7qp5fOMSn/DsVbXNhNG6HY+i+ePy5VFmvJ
// SIG // E6P9MYIEnzCCBJsCAQEwgZAweTELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENvZGUgU2ln
// SIG // bmluZyBQQ0ECEzMAAADKbNUyEjXE4VUAAQAAAMowCQYF
// SIG // Kw4DAhoFAKCBuDAZBgkqhkiG9w0BCQMxDAYKKwYBBAGC
// SIG // NwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIB
// SIG // FTAjBgkqhkiG9w0BCQQxFgQUqJZ7HrhtPj1z196p55j1
// SIG // EMBlRKAwWAYKKwYBBAGCNwIBDDFKMEigLoAsAE0AYQBu
// SIG // AGEAZwBlAGQASABlAGEAcABWAGkAZQB3AGUAcgBfADIA
// SIG // LgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJ
// SIG // KoZIhvcNAQEBBQAEggEAjeNymSspe7iLCH8YdhcBWGrB
// SIG // vMaooQVmw9DUXoowGqdqWhssIPVA+ezOo9MoM6O7+sD7
// SIG // GYrQKrxlNlvqxPR+d0tB+MvEMVW3FRX96XQwe56bmD8m
// SIG // pnQV9F8lYA1y/w92aOZt3wfKMaCJQDJbdcKJHtSFVU5w
// SIG // gcUYRCC1WOcghhWgH/+ms0BuTH5OwOg/ab5Sp1avFO0d
// SIG // 9JUZhhF0AvmA1UJ8OS0PgrEnOJfbGhGD6vNztnifxlzy
// SIG // UsRjpmlLPJmh47IgVCTJJcTOod1fSImozsakEnX7L0oF
// SIG // BB238/ve3p0TsfQqi2wCWgtpbKi1oJ6eYOeSq3i1dJs5
// SIG // W4vh2pCVl6GCAigwggIkBgkqhkiG9w0BCQYxggIVMIIC
// SIG // EQIBATCBjjB3MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEwHwYD
// SIG // VQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0ECEzMA
// SIG // AABa7S/05CCZPzoAAAAAAFowCQYFKw4DAhoFAKBdMBgG
// SIG // CSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcN
// SIG // AQkFMQ8XDTE0MDcyMzA5MTEwMVowIwYJKoZIhvcNAQkE
// SIG // MRYEFE+ks3kuNuOzLL9AgcA0xxubd0pKMA0GCSqGSIb3
// SIG // DQEBBQUABIIBAFX/c/ejTnAZeSjRe9y7kh/cBia7p3wT
// SIG // 0mgx5ILp5GtRR9anhd7ewJ+wAfqvVYvUShtqC2KXnKLO
// SIG // 46bJLhTjKT71fevfoRvlter0uCtobBWoXm+vZVu7zYiv
// SIG // UQ4M//5Q9sGI6Bpg2v+IvxAiYHayORieFiT+G2H7pvYF
// SIG // 3c7y8s4SWDPqplcsbRYpcK/b4fueW6YxItgUYvIi8Rg5
// SIG // U8CUd+Qn/zIwPwwX153BNYPaMUdDUFyuTvUybJV9ASx+
// SIG // Ih8dcJjuTpZvyr8BOiIEzHBriS4kk4DBJ5olHxmcaWS0
// SIG // NlnmS67sxFkyoy2lsTBnKgG4bEZOktkkWmtPL1XU4Kpix4Y=
// SIG // End signature block
